/***************************************************************************
                           chttp.h  -  description
                             -------------------
    begin                : Mon Jul 29 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHTTP_H
#define CHTTP_H

/**
  *@author Mathias Kster
  */


#include <dclib/cobject.h>
#include <dclib/cbytearray.h>
#include <dclib/cconnection.h>

#include <dclib/dcos.h>

class DLL_EXPORT CHttp : public CConnection {
public:
	/** */
	CHttp();
	/** */
	virtual ~CHttp();

	/** */
	int GetUrl( CString url );

	/** callback function */
	virtual int DC_CallBack( CObject * ) { return -1; };
	/** */
	virtual void ConnectionState( eConnectionState );
	/** */
	virtual void DataAvailable( const char *, int );
	/** */
	virtual void DataSend();
	/** */
	virtual void DataTimeout();

private:
	/** */
	int CallBack_SendObject( CObject * Object );

	/** */
	eConnectionState eMode;
	/** */
	CString sUrl;
	/** */
	CString sHost;
	/** */
	CString sPort;
	/** */
	int iErrorCode;
	/** */
	bool bData;
	/** */
	CString sHeader;
	/** */
	CByteArray baData;
};

#endif
