/***************************************************************************
                          cquerymanager.h  -  description
                             -------------------
    begin                : Sat Jun 8 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CQUERYMANAGER_H
#define CQUERYMANAGER_H

#include <dclib/dcos.h>
#include <dclib/cobject.h>
#include <dclib/cthread.h>
#include <dclib/cmessagehandler.h>
#include <dclib/cfilemanager.h>

/**
  *@author Mathias Kster
  */

class CStringList;

class DLL_EXPORT CQueryObject : public CObject {
public:
	/** */
	CQueryObject() {};
	/** */
	virtual ~CQueryObject() {};

	/** */
	CString sHubName;
	/** */
	CString sHubHost;
	/** */
	CString sNick;
	/** */
	CMessageSearch * pMessageSearch;
	/** */
	time_t tTimeout;
};

class DLL_EXPORT CQueryResultObject : public CObject {
public:
	/** */
	CQueryResultObject() {};
	/** */
	virtual ~CQueryResultObject() {};

	/** */
	CString ID;
	/** */
	int iDepth;
};

class DLL_EXPORT CQueryManager : public CThread {
public: 
	CQueryManager();
	virtual ~CQueryManager();

	/** thread callbackfunction */
	virtual void Thread( CObject * Object );

	/* */
	bool SearchQuery( CString hubname, CString hubhost, CString nick, CMessageSearch * msg );

private:
	/** the search queue */
	CList<CQueryObject> * pQueryQueue;
};

extern CQueryManager * pQueryManager;

#endif
