/***************************************************************************
                           cstringlist.h  -  description
                             -------------------
    begin                : Sat Jun 1 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSTRINGLIST_H
#define CSTRINGLIST_H

#include <dclib/dcos.h>
#include <dclib/cobject.h>
#include <dclib/cstring.h>
#include <dclib/clist.h>
#include <dclib/cthread.h>

/**
  *@author Mathias Kster
  */

class DLL_EXPORT CStringListObject : public CObject {
public:
	CStringListObject() { pObject = 0; };
	virtual ~CStringListObject() {};
	CString s;
	CObject * pObject;
};

class DLL_EXPORT CStringList : public CObject {
public: 
	CStringList( int depth = 0 );
	virtual ~CStringList();

	/** */
	int Add( CString s, CObject * object = 0 );
	/** */
	int Get( CString s, CObject *& object );
	/** */
	int Del( CString s );
	/** */
	void Clear();
	/** */
	long Count() const;
	/** */
	int Next( CObject *& object );
	/** */
	int Next( CString & s, CObject *& object );
private:
	/** */
	int iDepth;
	/** */
	long size;
	/** */
	long pos_cache;
	/** */
	CStringListObject * obj_cache;
	/** */
	CStringList ** pStringList;
	/** */
	CList<CStringListObject> ** pList;
};

/** */
inline long CStringList::Count() const
{ return size; }

class DLL_EXPORT CThreadStringList : public CStringList, public CThread {
public:
	CThreadStringList( int depth = 0 ) : CStringList(depth) {};
	virtual ~CThreadStringList() {};
};

#endif
