#!/bin/sh

# Define the host to be updated as 1st arguement to script
if [ -z $1 ]; then
	echo "Usage: ddupcron.sh hostname [interface]"
	exit
else
	HOST=$1
fi
# Define interface to grep address from
if [ -z $2 ]; then
	IFACE=fxp0
else
	IFACE=$2
fi
IFCHECK=$(/sbin/ifconfig $IFACE|awk '/netmask/{print $2; exit}')
# Define where we should store last IP
IPFILE="/var/db/ddup.ip"
IPCHECK=$(cat $IPFILE)
FILECHECK=$(find $IPFILE -mtime -25)

# Define path to ddup and ddup arguments (except --host)
DDUP_PATH="%%PREFIX%%/sbin/ddup"
DDUP_ARGS="--debug"

if [ "$IFCHECK" = "$IPCHECK" ] && [ "x$FILECHECK" != x ]; then
	echo "looks like we are still the same ip"
else
	$DDUP_PATH --host $HOST $DDUP_ARGS
	echo "$IFCHECK" > $IPFILE
fi
