/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* diabasemodifytool.h
 * -------------------
 * The DiaBaseModifyTool is responsible for forwarding events to the DiaObject
 * event handler and handling the requests the object places in its REQUEST
 * field. DiaBaseModifyTool shoudl not be used directly: use DiaModifyTool or
 * DiaCreateTool (which will create objects on the canvas).
 */

#ifndef __DIA_BASE_MODIFY_TOOL_H__
#define __DIA_BASE_MODIFY_TOOL_H__

#include <diacanvas/geometry.h>
#include <diacanvas/diatool.h>
#include <diacanvas/diadefs.h>

DIA_OPEN

typedef struct _DiaBaseModifyTool DiaBaseModifyTool;

#define DIA_HANDLE_CLICK_DISTANCE 3.5 /* distance in canvas pixels */

struct _DiaBaseModifyTool
{
  DiaTool tool;
};

void dia_base_modify_tool_init (DiaBaseModifyTool *tool);

DiaTool* dia_base_modify_tool_new ();

/* handle request that only apply to the actual object being affected by an
 * event (not selected objects!).
 * handled events:
 *   DIA_REQUEST_SELECT, DIA_REQUEST_UNSELECT, DIA_REQUEST_FOCUS,
 *   DIA_REQUEST_UNFOCUS, DIA_REQUEST_GRAB, DIA_REQUEST_UNGRAB,
 *   DIA_REQUEST_CURSOR, DIA_REQUEST_CURSOR_RESET.
*/
void dia_base_modify_tool_handle_requests_1 (DiaDisplay *ddisp,
					     DiaObject *object,
					     DiaEvent *event,
					     DiaLayer *layer);

/* These requests also apply to selected objects.
 * handled events are:
 *   DIA_REQUEST_REDRAW, DIA_REQUEST_DESTROY, DIA_REQUEST_EXTENTS,
 *   DIA_REQUEST_NORMAL, DIA_REQUEST_UPDATE_CONNECTIONS.
 */
void dia_base_modify_tool_handle_requests_2 (DiaDisplay *ddisp,
					     DiaObject *object,
					     DiaEvent *event,
					     DiaLayer *layer);


DIA_CLOSE

#endif /* __BASE_MODIFY_TOOL_H__ */






