/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* diabox.h
 * ----------------
 * This is a simple rectangle.
 */

#ifndef __DIA_BOX_H__
#define __DIA_BOX_H__

#include <diacanvas/diadynelement.h> /* parent object */

DIA_OPEN

#define DIA_BOX(x) ((DiaBox*) x)

typedef struct _DiaBox DiaBox;

struct _DiaBox
{
  DiaDynElement   element;

  DiaColor         line_color;
  DiaColor         fill_color;
  DiaLineCaps      line_caps;
  DiaLineJoin      line_join;
  DiaLineStyle     line_style;
  gfloat           line_width;
};

DiaObjectType* dia_box_get_type ();

void dia_box_init (DiaBox *box);

DiaObject* dia_box_new (Point *point);

DiaObject* dia_box_new_full (Point *pos, gfloat width, gfloat height);

DIA_CLOSE

#endif /* __DIA_BOX_H__ */



