/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/* Original license:
 *  Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __DIA_RENDERER_EPS_H__
#define __DIA_RENDERER_EPS_H__

#include <stdio.h>
#include <diacanvas/geometry.h>
#include <diacanvas/diarenderer.h>
#include <diacanvas/diadiagram.h>
#include <diacanvas/diadefs.h>

DIA_OPEN

typedef struct _DiaRendererEps DiaRendererEps;

struct _DiaRendererEps {
  DiaRenderer renderer;

  FILE *file;

  DiaLineStyle saved_line_style;
  gfloat dash_length;
  gfloat dot_length;
};

DiaRendererEps* dia_renderer_eps_new (DiaDiagram *dia, gchar *filename);

DiaRendererEps* dia_renderer_eps_new_scale (DiaDiagram *dia,
					    gchar *filename,
					    gdouble scale);

/* Close the output file and free the memory: */
void dia_renderer_eps_destroy (DiaRendererEps *renderer);


DIA_CLOSE

#endif /* RENDER_EPS_H */






