/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/* Original license:
 * Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* diarenderergdk.h
 * ----------------
 * The renderer used by DiaDisplay to create the contents of the canvas
 */
#ifndef __DIA_RENDERER_GDK_H__
#define __DIA_RENDERER_GDK_H__

#define DIA_RENDERER_GDK(ren) ((DiaRendererGdk*) ren)

typedef struct _DiaRendererGdk DiaRendererGdk;

#include <diacanvas/diarenderer.h>
#include <diacanvas/diadisplay.h>

struct _DiaRendererGdk
{
  DiaRenderer renderer;

  DiaDisplay *ddisp;
  GdkPixmap *pixmap;              /* The pixmap shown in this display  */
  guint32 width;                  /* The width of the pixmap in pixels */
  guint32 height;                 /* The height of the pixmap in pixels */
  GdkGC *render_gc;
  GdkRegion *clip_region;

  /* line attributes: */
  gint line_width;
  GdkLineStyle line_style;
  GdkCapStyle cap_style;
  GdkJoinStyle join_style;

  DiaLineStyle saved_line_style;
  gint dash_length;
  gint dot_length;

  GdkFont *gdk_font;
  gint font_height;
};

DiaRendererGdk *dia_renderer_gdk_new (DiaDisplay *ddisp);

void dia_renderer_gdk_destroy (DiaRendererGdk *renderer);

void dia_renderer_gdk_set_size (DiaRendererGdk *renderer, GdkWindow *window,
				gint width, gint height);

void dia_renderer_gdk_copy_to_window (DiaRendererGdk *renderer,
				      GdkWindow *window,
				      gint x, gint y,
				      gint width, gint height);

DIA_CLOSE

#endif /* __DIA_RENDERER_GDK_H__ */


