/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* diaboxelement.h
 * ---------------
 * This is a simple rectangle.
 */

#ifndef __DIA_BOX_ELEMENT_H__
#define __DIA_BOX_ELEMENT_H__

#include <diacanvas/diaelement.h> /* parent object */

DIA_OPEN

#define DIA_BOX_ELEMENT(x) ((DiaBoxElement*) x)

typedef struct _DiaBoxElement DiaBoxElement;

struct _DiaBoxElement
{
  DiaElement       element;

  DiaColor         line_color;
  DiaColor         fill_color;
  DiaLineCaps      line_caps;
  DiaLineJoin      line_join;
  DiaLineStyle     line_style;
  gfloat           line_width;
};

DiaObjectType* dia_box_element_get_type ();

void dia_box_element_init (DiaBoxElement *box);

DiaObject* dia_box_element_new (gfloat x, gfloat y,
				gfloat width, gfloat height);

gboolean dia_box_element_find_intersection (DiaBoxElement *elem,
					    DiaHandle *h, Point *pos);

DIA_CLOSE

#endif /* __DIA_BOX_ELEMENT_H__ */



