/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* diacreatetool.h
 * ---------------
 * Create tool is a tool specialized for placing objects on the canvas.
 */

#ifndef __DIA_CREATE_TOOL_H__
#define __DIA_CREATE_TOOL_H__

#include <diacanvas/diabasemodifytool.h>

DIA_OPEN

typedef struct _DiaCreateTool DiaCreateTool;

struct _DiaCreateTool
{
  DiaBaseModifyTool tool;

  DiaObjectType *object_type;
  
  guint signal_handler_id;

  guint added; /* the amount of objects added so far. */
};

DiaTool* dia_create_tool_new (DiaObjectType *object_type);

DIA_CLOSE

#endif /* CREATE_TOOL_H */













