/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* diadynelement.h
 * ----------------
 * This is a simple (shapeless) object that has the abillity to connect
 * other objects on its bounding-box. This is extremely handy if you are
 * creating objects where the place where another object is connected
 * doesn't matter.
 */

#ifndef __DIA_DYN_ELEMENT_H__
#define __DIA_DYN_ELEMENT_H__

#include <diacanvas/diabaseelement.h> /* parent object */

DIA_OPEN

#define DIA_DYN_ELEMENT(x) ((DiaDynElement*) x)

typedef struct _DiaDynElement DiaDynElement;

struct _DiaDynElement
{
  DiaBaseElement   element;
};

DiaObjectType* dia_dyn_element_get_type ();

void dia_dyn_element_init (DiaDynElement *element);

void dia_dyn_element_create_cp_data (DiaDynElement *elem,
				     DiaConnectionPoint *cp);

DIA_CLOSE

#endif /* __DIA_DYN_ELEMENT_H__ */



