/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* diadynline.h
 * ------------
 * This is basically a line, it only has the abbility to create connection
 * points on the fly.
 */

#ifndef __DIA_DYN_LINE_H__
#define __DIA_DYN_LINE_H__

#include <diacanvas/diabaseline.h> /* parent object */

DIA_OPEN

#define DIA_DYN_LINE(x) ((DiaDynLine*) x)

typedef struct _DiaDynLine DiaDynLine;

struct _DiaDynLine
{
  DiaBaseLine   line;
};

DiaObjectType* dia_dyn_line_get_type ();

void dia_dyn_line_init (DiaDynLine *line);

DiaObject* dia_dyn_line_new (Point *pos);


DIA_CLOSE

#endif /* __DIA_DYN_LINE_H__ */



