/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* diaelement.h
 * ------------
 * This is the kind of object you should inherid from if you want to use
 * graphs (or at least DiaGraph). Graph theory is based on objects (elements)
 * which are connected by a line, or graph.
 *
 * DiaElement itself does not have a _new method. That's because it has no
 * shape. DiaElement is used as a class that offers basic behaviour for
 * elements (only DiaGraph objects could connect to it!).
 */

#ifndef __DIA_ELEMENT_H__
#define __DIA_ELEMENT_H__

#include <diacanvas/diadynelement.h>
DIA_OPEN

#define DIA_ELEMENT(x) ((DiaElement*) x)

typedef struct _DiaElement DiaElement;

#include <diacanvas/diagraph.h>

struct _DiaElement
{
  DiaDynElement   element;
};

DiaObjectType* dia_element_get_type ();

void dia_element_init (DiaElement *element);


DIA_CLOSE

#endif /* __DIA_ELEMENT_H__ */



