/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/* Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __DIA_FONT_H__
#define __DIA_FONT_H__

#include <gdk/gdk.h>
#include <diacanvas/geometry.h>
#include <diacanvas/diadefs.h>

DIA_OPEN

typedef enum
{
  DIA_ALIGN_LEFT,
  DIA_ALIGN_CENTER,
  DIA_ALIGN_RIGHT
} DiaHAlignment;

typedef enum 
{
  DIA_ALIGN_TOP,
  DIA_ALIGN_MIDDLE,
  DIA_ALIGN_BOTTOM
} DiaVAlignment;

typedef struct _DiaFont DiaFont;

struct _DiaFont {
  char *name;
};

extern GList *dia_font_names; /* GList with 'char *' data.*/

void dia_font_init ();
DiaFont *dia_font_get_font (const gchar *name);
GdkFont *dia_font_get_gdkfont (DiaFont *font, gint height);
gchar *dia_font_get_psfontname (DiaFont *font);
gfloat dia_font_string_width (const gchar *string, DiaFont *font,
			      gfloat height);
gfloat dia_font_ascent (DiaFont *font, gfloat height);
gfloat dia_font_descent (DiaFont *font, gfloat height);

DIA_CLOSE

#endif /* __DIA_FONT_H__ */

