/*
 compile with:
 gcc `gtk-config --cflags` -o example example.c `gtk-config --libs` libeasygtk.a
*/

#include "easygtk.h"
#include "test.xpm"

void cb_wizard2();
void cb_wizard3();
void cb_wizard4();
void cb_endwizard();

GtkWidget *win, *win2, *box, *box2, *label, *entry, *entry2, *button, *list, *check, *nb, *fs, *br, *tb, *browse;
E_Wizard *wiz;
E_Editor editor;

/* creates a small editor */
void cb_editor_close()
{
 gtk_widget_destroy(editor.window);
}

void cb_editor_new()
{
 e_text_delete(editor.text);
 gtk_window_set_title(GTK_WINDOW(wiz->window), "Untitled");
}

void cb_editor_open_ok()
{
 strcpy(editor.filename, e_browse_get(browse));
 e_text_insert_file(editor.text, editor.filename);
 gtk_window_set_title(GTK_WINDOW(wiz->window), editor.filename);
 gtk_widget_destroy(browse);
}

void cb_editor_open_cancel()
{
 gtk_widget_destroy(browse);
}

void cb_editor_save()
{
 FILE *fd;
 fd = fopen(editor.filename, "w");
 fputs(e_text_get(editor.text), fd);
 fclose(fd);
}

void cb_editor_open()
{
 browse = e_browse_create("Open file", cb_editor_open_ok, cb_editor_open_cancel);
}

void cb_editor()
{
 editor.menu_file = TRUE;
 editor.menu_edit = FALSE;
 editor.menu_help = FALSE;
 editor.init_load = FALSE;
 editor.editable = TRUE;
 editor.menu_new = GTK_SIGNAL_FUNC(cb_editor_new);
 editor.menu_open = GTK_SIGNAL_FUNC(cb_editor_open);
 editor.menu_save = GTK_SIGNAL_FUNC(cb_editor_save);
 editor.menu_close = GTK_SIGNAL_FUNC(cb_editor_close);
 strcpy(editor.filename, "Untitled");
 e_editor_create(&editor);
}

/* this is called when the user closes the window */
void cb_exit()
{
 e_show_message("EasyGTK Example", "You decided to quit!", exit);
}

/* these are examples of a wizard */
void cb_wizard1()
{
 if(wiz!=NULL && GTK_IS_WIDGET(wiz->window)) gtk_widget_destroy(wiz->window);
 wiz = (E_Wizard*)e_wizard_create("Example Wizard", e_pixmap_create(test_xpm, win->window), "Welcome to this Example Wizard!\n\nIn this wizard, we will install no program, and we will do no modification to your system. In a real wizard however, you could install a software program, or help the user in some task.\n\nPlease read the following copyright information:\n\nTHIS EXAMPLE AND THIS LIBRARY COME WITH NO WARRANTY WHATSOEVER. I put it in caps to be sure everyone would see it. You are on your own if you scrap your system with this.", FALSE, E_NO_FUNC, cb_wizard2, cb_endwizard);
}

void cb_wizard2()
{
 if(GTK_IS_WIDGET(wiz->window)) gtk_widget_destroy(wiz->window);
 wiz = (E_Wizard*)e_wizard_create("Example Wizard", e_pixmap_create(test_xpm, win->window), "This page will ask for some information about yourself.\n\nPlease enter your name in the entry box below.", TRUE, cb_wizard1, cb_wizard3, cb_endwizard);
}

void cb_wizard3()
{
 printf("You entered: %s\n", e_entry_get(wiz->entry));
 if(GTK_IS_WIDGET(wiz->window)) gtk_widget_destroy(wiz->window);
 wiz = (E_Wizard*)e_wizard_create("Example Wizard", e_pixmap_create(test_xpm, win->window), "This page will ask for some information about yourself.\n\nPlease enter your age", TRUE, cb_wizard2, cb_wizard4, cb_endwizard);
}

void cb_wizard4()
{
 printf("You entered: %s\n", e_entry_get(wiz->entry));
 gtk_widget_destroy(wiz->window);
}

void cb_endwizard()
{
 gtk_widget_destroy(wiz->window);
}

/* cancel for the add command */
void cb_cancel()
{
 gtk_widget_destroy(win2);
}

/* this adds an item to the list */
void cb_ok()
{
 char *items[2] = { e_entry_get(entry), e_entry_get(entry2) };
 e_list_insert(list, items);
 gtk_widget_destroy(win2);
}

/* this prints the current selected item from the list */
void cb_print(GtkWidget *w, int c, int r)
{
 printf("%s\n", e_list_get());
}

/* this is the entry window to add items to the list */
void cb_add()
{
 win2 = e_window_create("Name Example", 400, 200, 150, 150, E_NO_FUNC);
 box = e_box_create(win2, E_VERTICAL, 2);
 box2 = e_box_create(box, E_HORIZONTAL, 0);
 label = e_label_create(box2, "Enter a name:");
 entry = e_entry_create(box2, "");
 box2 = e_box_create(box, E_HORIZONTAL, 0);
 label = e_label_create(box2, "Enter a number:");
 entry2 = e_entry_create(box2, "");
#if 0
 box2 = e_buttonbox_create(box, E_SPREAD, "Ok", "Cancel", cb_ok, cb_cancel);
#else
 box2 = e_buttonbox_unlim(box, E_SPREAD, 2, "Ok", cb_ok, "Cancel", cb_cancel);
#endif
}

/* this will remove the selected item from the list */
void cb_rem()
{
 e_list_remove(list);
}

/* this will return the current state of the checkbox */
void cb_print_check()
{
 printf("%d\n", e_checkbutton_get(check));
}

/* font selection was canceled */
void cb_font_cancel()
{
 gtk_widget_destroy(fs);
}

/* user clicked on the ok button */
void cb_font_ok()
{
 printf("%s\n", e_font_get(fs));
 gtk_widget_destroy(fs);
}

/* display a font selection window */
void cb_font()
{
 fs = e_font_create("Select a font", cb_font_ok, cb_font_cancel);
}

#ifdef USE_IMLIB
/* some imaging example, the showing of an image */
void cb_show_cancel()
{
 gtk_widget_destroy(br);
}

void cb_show_ok()
{
 e_image_window(e_browse_get(br));
 gtk_widget_destroy(br);
}

void cb_show()
{
 br = e_browse_create("Pick an image", cb_show_ok, cb_show_cancel);
}
#endif

#ifdef USE_MAGICK
void cb_mag_cancel()
{
 gtk_widget_destroy(br);
}
 
void cb_mag_ok()
{
 if(fork()) e_image_display(e_browse_get(br));
 gtk_widget_destroy(br);
}
   
void cb_mag()
{
 br = e_browse_create("Pick an image", cb_mag_ok, cb_mag_cancel);
}
#endif

void cb_clicked()
{
 printf("click at: %d %d\n", e_event_get_x(), e_event_get_y());
}

void cb_textbox_close()
{
 gtk_widget_destroy(tb);
}

void cb_textbox()
{
 tb = e_show_textbox("This is a test", "Example textbox\n\nThis could really contain any text and this is only an example...", cb_textbox_close);
}

/* this will make the main window */
int main(int argc, char *argv[])
{
 char *rbitems[4] = { "Choice 1", "Choice 2", "Choice 3", "Choice 4" };
#ifdef USE_GNOME
 gnome_init("Example", "1.1", argc, argv);
#else
 gtk_init(&argc, &argv);
#endif
#ifdef USE_IMLIB
 gdk_init(&argc, &argv);
 gdk_imlib_init();
#endif
 printf("You are using EasyGTK version %s\n", E_VERSION);
 win = e_window_create("EasyGTK Example", 340, 450, 100, 100, exit);
 box = e_box_create(win, E_VERTICAL, 5);
 nb = e_notebook_create(box, E_TOP);
 box = e_notebook_new_page(nb, "List", "This is a list example");
 label = e_label_create(box, "This is an example list:");
 list = e_list_create(box, 2, cb_print);
 e_set_size(list, 200, 300);
 e_list_setup(list, 0, "Names", 100);
 e_list_setup(list, 1, "Numbers", 100);
 box2 = e_buttonbox_unlim(box, E_SPREAD, 3, "Add Item", cb_add, "Remove Item", cb_rem, "Quit", exit);
 box = e_notebook_new_page(nb, "Other", "These are other examples");
 check = e_checkbutton_create(box, "This is a test", TRUE, cb_print_check);
 e_radiobuttons_create(box, rbitems, 4);
 e_button_create(box, "Select a font", cb_font);
 e_button_create(box, "Leave EasyGTK Example", cb_exit);
 box = e_notebook_new_page(nb, "New", "Some newer stuff");
 label = e_pixmap_create(test_xpm, win->window);
 e_button_create_with_pixmap(box, label, E_NO_FUNC);
 e_button_create(box, "Text box", cb_textbox);
 e_button_create(box, "Wizard", cb_wizard1);
 e_button_create(box, "Editor", cb_editor);
#ifdef USE_IMLIB
 e_button_create(box, "Show image with IMlib", cb_show);
#endif
#ifdef USE_MAGICK
 e_button_create(box, "Show image with ImageMagick", cb_mag);
#endif
 box = e_notebook_new_page(nb, "Events", "Events example");
 box2 = e_event_create(box, 200, 300, cb_clicked);
#ifdef USE_IMLIB
 e_image_scaled(box2, "test.xpm", 200, 300);
#endif
 gtk_main();
 return 0;
}

