-----------------------------------------------------------
--                   Eiffel/S examples                   --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   LISTRACE

inherit
    MATH
    end

    SYSTEM_TIME
    end

creation
    make

feature

    a     : ARRAY [INTEGER] 
    io    : BASIC_IO 
    slist : SORTED_LIST [INTEGER] 
    llist : LINKED_LIST [INTEGER] 

    make is
        do
            !!io 

            build_array (8000)

            add_both (1000)
            add_both (2000)
            add_both (4000)
            add_both (8000)

            remove_both (8000)
        end
-----------------------------------------------------------

    build_array (n : INTEGER) is

        local 
            i : INTEGER

        do
            from
                !!a.make (1, n)
                i := 1
                srand (340189887)
            until
                i > n
            loop
                a.put (rand, i)
                i := i + 1
            end
        end

-----------------------------------------------------------

    add_both (n : INTEGER) is

        local
            i    : INTEGER
            time : INTEGER

        do
            io.put_string ("Inserting ")
            io.put_int (n)
            io.put_string (" integers%N")

            from
                !!llist.make (false)
                i    := 1
                time := sysclock
            until
                i > n
            loop
                llist.add (a.item (i))
                i := i + 1
            end

            io.put_string ("linked list : ")
            io.put_int (sysclock - time)
            io.put_string (" ms%N")

            from
                !!slist.make (false)
                i    := 1
                time := sysclock
            until
                i > n
            loop
                slist.add (a.item (i))
                i := i + 1
            end

            io.put_string ("sorted list : ")
            io.put_int (sysclock - time)
            io.put_string (" ms%N")
        end

-----------------------------------------------------------

    remove_both (n : INTEGER) is

        local
            i    : INTEGER
            time : INTEGER

        do
            io.put_string ("%NRemoving ")
            io.put_int (n)
            io.put_string (" integers%N")

            from
                i    := 1
                time := sysclock
            until
                i > n
            loop
                llist.remove (a.item (i))
                i := i + 1
            end

            io.put_string ("linked list : ")
            io.put_int (sysclock - time)
            io.put_string (" ms%N")

            from
                i    := 1
                time := sysclock
            until
                i > n
            loop
                slist.remove (a.item (i))
                i := i + 1
            end

            io.put_string ("sorted list : ")
            io.put_int (sysclock - time)
            io.put_string (" ms%N")
        end

end -- class LISTRACE

