-----------------------------------------------------------
--                   Eiffel/S examples                   --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------

  
  
class   QSORTER [G -> COMPARABLE]

feature

    sort (arr : ARRAY [G], lower, upper : INTEGER) is

        require
            lower <= upper
        do
            a := arr

            if upper > lower then
                quicksort (lower, upper)
            end
        end
-----------------------------------------------------------

    quicksort (left, right : INTEGER) is

        local
            lt, rt   : INTEGER
            l, r     : INTEGER
            pivot, x : G
        do
            from
                lt := left
                rt := right
            until
                lt >= rt
            loop
                pivot := a.item ((lt + rt) // 2)

                from
                    l := lt - 1
                    r := rt + 1
                invariant
                    -- a[lt .. l] <= pivot
                    -- a[r .. rt] >= pivot
                until
                    l >= r
                loop
                    from
                        r := r - 1
                    until
                        a.item (r) <= pivot
                    loop
                        r := r - 1
                    end

                    from
                        l := l + 1
                    until
                        a.item (l) >= pivot
                    loop
                        l := l + 1
                    end

                   if l < r then
                        x := a.item (l)
                        a.put (a.item (r), l)
                        a.put (x, r)
                    end
                end

                if (r - lt) < (rt - r) then
                    if lt < r then
                        quicksort (lt, r)
                    end

                    lt := r + 1
                else
                    if r + 1 < rt then
                        quicksort (r + 1, rt)
                    end

                    rt := r
                end
            end
        end
-----------------------------------------------------------
 
feature { NONE } 
 
    a : ARRAY [G] 

end -- class QSORTER

