-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   FORMAT

-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    i2s (format : STRING, value : INTEGER) : STRING is

        require
            format_not_void : format /= Void
            legal_format    : -- `format' must be a legal
                              -- format string
        do
            Result := rt_i2s (format.to_external, value)
        end
-----------------------------------------------------------

    s2i (text : STRING) : INTEGER is
    
        require
            text_not_void        : text /= Void
            valid_integer_string : -- `text' must represent an integer
        do
            Result := rt_s2i (text.to_external)
        end
-----------------------------------------------------------

    r2s (format : STRING, value : REAL) : STRING is

        require
            format_not_void : format /= Void
            legal_format    : -- `format' must be a legal
                              -- format string
        do
            Result := rt_r2s (format.to_external, value)
        end
-----------------------------------------------------------

    s2r (text : STRING) : REAL is
    
        require
            text_not_void     : text /= Void
            valid_real_string : -- `text' must represent a real
        do
            Result := rt_s2r (text.to_external)
        end
-----------------------------------------------------------

    c2s (c : CHARACTER) : STRING is

        do
            !!Result.make (1)
            Result.put (c, 1)
        end
-----------------------------------------------------------

    s2s (format : STRING, text : STRING) : STRING is

        require
            format_not_void : format /= Void
            text_not_void   : text /= Void
        do
            Result := rt_s2s (format.to_external, text.to_external)
        end
-----------------------------------------------------------

    s2c (text : STRING) : CHARACTER is

        require
            long_enough : text /= Void and then text.count > 0
        do
            Result := text.item (1)
        end
-----------------------------------------------------------

    b2s (b : BOOLEAN) : STRING is

        do
            if b then
                Result := "true"
            else
                Result := "false"
            end
        end
-----------------------------------------------------------

    s2b (text : STRING) : BOOLEAN is

        require
            text_not_void        : text /= Void
            valid_boolean_string : -- `text' must represent a boolean
        do
            Result := rt_s2b (text.to_external)
        end
-----------------------------------------------------------
feature {NONE}
-----------------------------------------------------------

    rt_i2s (format : POINTER, value : INTEGER) : STRING is

        external "C" -- changed by x_c_cwc
        alias    "RTC10_i2s"
        end
-----------------------------------------------------------

    rt_s2i (text : POINTER) : INTEGER is
    
        external "C" -- changed by x_c_cwc
        alias    "RTC10_s2i"
        end
-----------------------------------------------------------

    rt_r2s (format : POINTER, value : REAL) : STRING is

        external "C" -- changed by x_c_cwc
        alias    "RTC10_r2s"
        end
-----------------------------------------------------------

    rt_s2r (text : POINTER) : REAL is
    
        external "C" -- changed by x_c_cwc
        alias    "RTC10_s2r"
        end
-----------------------------------------------------------

    rt_s2b (text : POINTER) : BOOLEAN is

        external "C" -- changed by x_c_cwc
        alias    "RTC10_s2b"
        end
-----------------------------------------------------------

    rt_s2s (format : POINTER, text : POINTER) : STRING is

        external "C" -- changed by x_c_cwc
        alias    "RTC10_s2s"
        end
-----------------------------------------------------------

end -- class FORMAT

