/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import COM.rsa.jsafe.a6;
import COM.rsa.jsafe.av;
import COM.rsa.jsafe.b0;
import COM.rsa.jsafe.bu;
import com.sun.net.ssl.internal.ssl.ContentInfo;
import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.MacData;
import com.sun.net.ssl.internal.ssl.ObjectIdentifier;
import com.sun.net.ssl.internal.ssl.b3;
import com.sun.net.ssl.internal.ssl.bz;
import com.sun.net.ssl.internal.ssl.u;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

public final class PKCS12KeyStore
extends KeyStoreSpi {
    public static final int VERSION_3 = 3;
    private static final ObjectIdentifier a = new ObjectIdentifier("1.2.840.113549.1.12.10.1.2");
    private static final ObjectIdentifier b = new ObjectIdentifier("1.2.840.113549.1.12.10.1.3");
    private static final ObjectIdentifier c = new ObjectIdentifier("1.2.840.113549.1.9.20");
    private static final ObjectIdentifier d = new ObjectIdentifier("1.2.840.113549.1.9.21");
    private static final int e = 20;
    private Hashtable f = new Hashtable();
    private ArrayList g = new ArrayList();
    private HashMap h = new HashMap();
    private int i = 1;

    private static void a(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4 = n3 / byArray.length;
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            System.arraycopy(byArray, 0, byArray2, n6 + n2, byArray.length);
            ++n5;
            n6 += byArray.length;
        }
        System.arraycopy(byArray, 0, byArray2, n6 + n2, n3 - n6);
    }

    private static byte[] a(char[] cArray, byte[] byArray, int n2, int n3, int n4) {
        int n5 = cArray.length;
        if ((n5 *= 2) > 0) {
            n5 += 2;
        }
        byte[] byArray2 = new byte[n5];
        int n6 = 0;
        int n7 = 0;
        while (n6 < cArray.length) {
            byArray2[n7] = (byte)(cArray[n6] >>> 8 & 0xFF);
            byArray2[n7 + 1] = (byte)(cArray[n6] & 0xFF);
            ++n6;
            n7 += 2;
        }
        int n8 = 64;
        int n9 = 20;
        int n10 = PKCS12KeyStore.a(n3, n9) / n9;
        byte[] byArray3 = new byte[n8];
        int n11 = PKCS12KeyStore.a(byArray.length, n8);
        int n12 = PKCS12KeyStore.a(byArray2.length, n8);
        byte[] byArray4 = new byte[n11 + n12];
        byte[] byArray5 = new byte[n3];
        u.a(byArray3, (byte)n4);
        PKCS12KeyStore.a(byArray, byArray4, 0, n11);
        PKCS12KeyStore.a(byArray2, byArray4, n11, n12);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray6 = new byte[n8];
            byte[] byArray7 = new byte[n8];
            int n13 = 0;
            while (true) {
                messageDigest.update(byArray3);
                messageDigest.update(byArray4);
                byte[] byArray8 = messageDigest.digest();
                int n14 = 1;
                while (n14 < n2) {
                    byArray8 = messageDigest.digest(byArray8);
                    ++n14;
                }
                System.arraycopy(byArray8, 0, byArray5, n9 * n13, Math.min(n3, n9));
                if (n13 + 1 != n10) {
                    PKCS12KeyStore.a(byArray8, byArray6, 0, byArray6.length);
                    BigInteger bigInteger = new BigInteger(1, byArray6).add(BigInteger.ONE);
                    int n15 = 0;
                    while (n15 < byArray4.length) {
                        if (byArray7.length != n8) {
                            byArray7 = new byte[n8];
                        }
                        System.arraycopy(byArray4, n15, byArray7, 0, n8);
                        BigInteger bigInteger2 = new BigInteger(1, byArray7);
                        bigInteger2 = bigInteger2.add(bigInteger);
                        byArray7 = bigInteger2.toByteArray();
                        int n16 = byArray7.length - n8;
                        if (n16 >= 0) {
                            System.arraycopy(byArray7, n16, byArray4, n15, n8);
                        } else if (n16 < 0) {
                            u.a(byArray4, n15, n15 + -n16, (byte)0);
                            System.arraycopy(byArray7, 0, byArray4, n15 + -n16, byArray7.length);
                        }
                        n15 += n8;
                    }
                    ++n13;
                    n3 -= n9;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("internal error: " + exception);
        }
        return byArray5;
    }

    static byte[] a(char[] cArray, byte[] byArray, int n2, int n3) {
        return PKCS12KeyStore.a(cArray, byArray, n2, n3, 2);
    }

    static byte[] b(char[] cArray, byte[] byArray, int n2, int n3) {
        return PKCS12KeyStore.a(cArray, byArray, n2, n3, 1);
    }

    static byte[] c(char[] cArray, byte[] byArray, int n2, int n3) {
        return PKCS12KeyStore.a(cArray, byArray, n2, n3, 3);
    }

    private static byte[] a(a6 a62, byte[] byArray) throws Exception {
        byte[] byArray2;
        int n2 = a62.a(byArray.length);
        byte[] byArray3 = new byte[n2];
        int n3 = 0;
        n3 = a62.a(byArray, 0, byArray.length, byArray3, 0);
        if ((n3 += a62.a(byArray3, n3)) < byArray3.length) {
            byArray2 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        } else {
            byArray2 = byArray3;
        }
        return byArray2;
    }

    public Enumeration engineAliases() {
        return this.f.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.f.containsKey(string.toLowerCase());
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable hashtable = this.f;
        synchronized (hashtable) {
            this.f.remove(string.toLowerCase());
        }
    }

    public Certificate engineGetCertificate(String string) {
        Object v2 = this.f.get(string.toLowerCase());
        if (v2 != null) {
            if (v2 instanceof b3) {
                return ((b3)v2).c;
            }
            if (((bz)v2).d == null) {
                return null;
            }
            return ((bz)v2).d[0];
        }
        return null;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.f.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v2 = this.f.get(string);
            if (v2 instanceof b3) {
                certificate2 = ((b3)v2).c;
            } else {
                if (((bz)v2).d == null) continue;
                certificate2 = ((bz)v2).d[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Object v2 = this.f.get(string.toLowerCase());
        if (v2 != null && v2 instanceof bz) {
            if (((bz)v2).d == null) {
                return null;
            }
            return (Certificate[])((bz)v2).d.clone();
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        Object v2 = this.f.get(string.toLowerCase());
        if (v2 != null) {
            if (v2 instanceof b3) {
                return new Date(((b3)v2).b.getTime());
            }
            return new Date(((bz)v2).b.getTime());
        }
        return null;
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object v2 = this.f.get(string.toLowerCase());
        PrivateKey privateKey = null;
        if (v2 == null || !(v2 instanceof bz)) {
            return null;
        }
        byte[] byArray = ((bz)v2).c;
        try {
            DerValue derValue = new DerValue(byArray);
            DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue()};
            if (derValue.data.available() != 0) {
                throw new IOException("overrun, bytes = " + derValue.data.available());
            }
            byte[] byArray2 = derValueArray[1].getOctetString();
            a6 a62 = a6.a(byArray, 0, "Java");
            bu bu2 = a62.g();
            bu2.a(cArray, 0, cArray.length);
            a62.a(bu2);
            if (!"3DES_EDE".equals(a62.m())) {
                throw new NoSuchAlgorithmException("3DES_EDE only for shrouded keys");
            }
            byte[] byArray3 = PKCS12KeyStore.b(cArray, a62.u(), a62.q()[0], a62.q()[1] * a62.h());
            byte[] byArray4 = PKCS12KeyStore.a(cArray, a62.u(), a62.q()[0], a62.h());
            String string2 = String.valueOf(a62.m()) + "/" + a62.n() + "/" + a62.s();
            a62 = a6.a(string2, "Java");
            a62.c(byArray4, 0, byArray4.length);
            bu2 = a62.g();
            bu2.a(byArray3, 0, byArray3.length);
            a62.a(bu2);
            byte[] byArray5 = PKCS12KeyStore.a(a62, byArray2);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray5);
            av av2 = av.a(byArray5, 0, "Java");
            KeyFactory keyFactory = KeyFactory.getInstance(av2.b());
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException(exception.getMessage());
        }
        return privateKey;
    }

    public boolean engineIsCertificateEntry(String string) {
        Object v2 = this.f.get(string.toLowerCase());
        return v2 != null && v2 instanceof b3;
    }

    public boolean engineIsKeyEntry(String string) {
        Object v2 = this.f.get(string.toLowerCase());
        return v2 != null && v2 instanceof bz;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.f;
        synchronized (hashtable) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object var6_4 = null;
            Object var7_5 = null;
            Hashtable hashtable2 = null;
            Object var9_7 = null;
            Object var10_8 = null;
            if (inputStream == null) {
                return;
            }
            DerValue derValue = new DerValue(inputStream);
            DerInputStream derInputStream = derValue.toDerInputStream();
            int n2 = derInputStream.getInteger().toInt();
            if (n2 != 3) {
                throw new IOException("PKCS12 keystore not in version 3 format");
            }
            hashtable2 = new Hashtable(3);
            this.f.clear();
            ContentInfo contentInfo = new ContentInfo(derInputStream);
            ObjectIdentifier objectIdentifier = contentInfo.getContentType();
            if (!objectIdentifier.equals(ContentInfo.DATA_OID)) {
                throw new IOException("public key protected PKCS12 not supported");
            }
            byte[] byArray = contentInfo.getData();
            DerInputStream derInputStream2 = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream2.getSequence(2);
            int n3 = derValueArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block23: {
                    void var21_25;
                    block22: {
                        block21: {
                            object4 = null;
                            object3 = new DerInputStream(derValueArray[n4].toByteArray());
                            object2 = new ContentInfo((DerInputStream)object3);
                            objectIdentifier = ((ContentInfo)object2).getContentType();
                            Object var21_21 = null;
                            if (!objectIdentifier.equals(ContentInfo.DATA_OID)) break block21;
                            byte[] byArray2 = ((ContentInfo)object2).getData();
                            break block22;
                        }
                        if (!objectIdentifier.equals(ContentInfo.ENCRYPTED_DATA_OID)) throw new IOException("public key protected PKCS12 not supported");
                        if (cArray != null) {
                            object = ((ContentInfo)object2).getContent().toDerInputStream();
                            int n5 = ((DerInputStream)object).getInteger().toInt();
                            DerValue[] derValueArray2 = ((DerInputStream)object).getSequence(2);
                            ObjectIdentifier objectIdentifier2 = derValueArray2[0].getOID();
                            object4 = derValueArray2[1].toByteArray();
                            if (!derValueArray2[2].isContextSpecific((byte)0)) {
                                throw new IOException("encrypted content not present!");
                            }
                            byte by2 = 4;
                            if (derValueArray2[2].isConstructed()) {
                                by2 = (byte)(by2 | 0x20);
                            }
                            derValueArray2[2].resetTag(by2);
                            byte[] byArray3 = derValueArray2[2].getOctetString();
                            try {
                                a6 a62 = a6.a((byte[])object4, 0, "Java");
                                bu bu2 = a62.g();
                                bu2.a(cArray, 0, cArray.length);
                                a62.a(bu2);
                                if (!"RC2".equals(a62.m())) {
                                    throw new NoSuchAlgorithmException("RC2 Only for safeContents");
                                }
                                byte[] byArray4 = bu2.n();
                                byte[] byArray5 = a62.p();
                                int[] nArray = a62.q();
                                String string = "RC2-" + nArray[1] + "/CBC/PKCS5Padding";
                                a62 = a6.a(string, "Java");
                                a62.c(byArray5, 0, byArray5.length);
                                bu2 = a62.g();
                                bu2.a(byArray4, 0, byArray4.length);
                                a62.a(bu2);
                                byte[] byArray6 = PKCS12KeyStore.a(a62, byArray3);
                            }
                            catch (Exception exception) {
                                throw new IOException("failed to decrypt safe contents entry");
                            }
                        }
                        break block23;
                    }
                    object = new DerInputStream((byte[])var21_25);
                    this.a((DerInputStream)object, cArray);
                }
                ++n4;
            }
            if (cArray != null && derInputStream.available() > 0) {
                MacData macData = new MacData(derInputStream);
                try {
                    object2 = macData.getDigestAlgName().toUpperCase();
                    object3 = b0.a("HMAC/" + (String)object2, "Java");
                    object4 = PKCS12KeyStore.c(cArray, macData.getSalt(), macData.getIterations(), 20);
                    object = ((b0)object3).c();
                    ((bu)object).a((byte[])object4, 0, ((Object)object4).length);
                    ((b0)object3).a((bu)object, new SecureRandom());
                    ((b0)object3).a(byArray, 0, byArray.length);
                    byte[] byArray7 = ((b0)object3).i();
                    if (!u.a(macData.getDigest(), byArray7)) {
                        throw new SecurityException("Failed PKCS12 integrity checking");
                    }
                }
                catch (Exception exception) {
                    throw new IOException("integrity check: " + exception);
                }
            }
            Object[] objectArray = this.g.toArray();
            int n6 = 0;
            while (n6 < objectArray.length) {
                object3 = (bz)objectArray[n6];
                if (((bz)object3).e != null) {
                    object4 = new ArrayList();
                    object = (X509Certificate)this.h.get(new KeyId(((bz)object3).e));
                    while (object != null) {
                        ((ArrayList)object4).add(object);
                        if (((X509Certificate)object).getIssuerDN().equals(((X509Certificate)object).getSubjectDN())) break;
                        object = (X509Certificate)this.h.get(((X509Certificate)object).getIssuerDN());
                    }
                    if (((ArrayList)object4).size() > 0) {
                        ((bz)object3).d = ((ArrayList)object4).toArray(new Certificate[((ArrayList)object4).size()]);
                    }
                }
                ++n6;
            }
            this.h.clear();
            this.g.clear();
            return;
        }
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable hashtable = this.f;
        synchronized (hashtable) {
            Object v2 = this.f.get(string.toLowerCase());
            if (v2 != null && v2 instanceof bz) {
                throw new KeyStoreException("Cannot overwrite own certificate");
            }
            b3 b32 = new b3(this);
            b32.c = certificate;
            b32.b = new Date();
            this.f.put(string.toLowerCase(), b32);
        }
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            Hashtable hashtable = this.f;
            synchronized (hashtable) {
                bz bz2 = new bz(this);
                bz2.b = new Date();
                if (certificateArray != null) {
                    bz2.d = (Certificate[])certificateArray.clone();
                }
                this.f.put(string.toLowerCase(), bz2);
            }
        }
        catch (Exception exception) {
            throw new KeyStoreException("Key protection algorithm not found");
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable hashtable = this.f;
        synchronized (hashtable) {
            bz bz2 = new bz(this);
            bz2.b = new Date();
            bz2.c = (byte[])byArray.clone();
            if (certificateArray != null) {
                bz2.d = (Certificate[])certificateArray.clone();
            }
            this.f.put(string.toLowerCase(), bz2);
        }
    }

    public int engineSize() {
        return this.f.size();
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.f;
        synchronized (hashtable) {
            throw new IOException("PKCS 12 storing not implemented");
        }
    }

    private void a(DerInputStream derInputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n2 = derValueArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DerValue[] derValueArray2;
            Object object;
            Object object2;
            Object object3;
            DerValue[] derValueArray3;
            DerValue[] derValueArray4 = null;
            DerInputStream derInputStream2 = derValueArray[n3].toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream2.getOID();
            DerValue derValue = derInputStream2.getDerValue();
            if (!derValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + derValue.tag);
            }
            derValue = derValue.data.getDerValue();
            if (objectIdentifier.equals(a)) {
                derValueArray3 = new bz(this);
                derValueArray3.c = derValue.toByteArray();
                derValueArray3.b = new Date();
                derValueArray4 = derValueArray3;
            } else if (objectIdentifier.equals(b)) {
                derValueArray3 = new DerInputStream(derValue.toByteArray());
                object3 = derValueArray3.getSequence(2);
                object2 = object3[0].getOID();
                if (!object3[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 cert value type " + object3[1].tag);
                }
                DerValue derValue2 = object3[1].data.getDerValue();
                object = CertificateFactory.getInstance("X509");
                derValueArray2 = (DerValue[])((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(derValue2.getOctetString()));
                derValueArray4 = derValueArray2;
            } else {
                throw new IOException("unsupported PKCS12 bag type " + objectIdentifier);
            }
            derValueArray3 = derInputStream2.getSet(2);
            object3 = null;
            object2 = null;
            int n4 = 0;
            while (n4 < derValueArray3.length) {
                object = new DerInputStream(derValueArray3[n4].toByteArray());
                derValueArray2 = ((DerInputStream)object).getSequence(2);
                ObjectIdentifier objectIdentifier2 = derValueArray2[0].getOID();
                DerInputStream derInputStream3 = new DerInputStream(derValueArray2[1].toByteArray());
                DerValue[] derValueArray5 = derInputStream3.getSet(2);
                if (objectIdentifier2.equals(c)) {
                    object3 = derValueArray5[0].getBMPString();
                } else if (objectIdentifier2.equals(d)) {
                    object2 = derValueArray5[0].getOctetString();
                } else {
                    System.out.println("unknown attr" + objectIdentifier2);
                }
                ++n4;
            }
            if (derValueArray4 instanceof bz) {
                object = (bz)derValueArray4;
                ((bz)object).e = (byte[])object2;
                ((bz)object).f = object3;
                this.g.add(object);
                this.f.put(object3.toLowerCase(), object);
            } else if (derValueArray4 instanceof X509Certificate) {
                object = (X509Certificate)derValueArray4;
                if (object2 != null) {
                    this.h.put(new KeyId((byte[])object2), derValueArray4);
                }
                if (object3 != null) {
                    this.h.put(object3, derValueArray4);
                }
                if (((X509Certificate)object).getSubjectDN() != null) {
                    this.h.put(((X509Certificate)object).getSubjectDN(), derValueArray4);
                }
            }
            ++n3;
        }
    }

    private static int a(int n2, int n3) {
        return (n2 + (n3 - 1)) / n3 * n3;
    }

    class KeyId {
        byte[] b;

        KeyId(byte[] byArray) {
            this.b = byArray;
        }

        public boolean equals(Object object) {
            if (!(object instanceof KeyId)) {
                return false;
            }
            KeyId keyId = (KeyId)object;
            if (this.b == keyId.b) {
                return true;
            }
            if (this.b.length != keyId.b.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.b.length) {
                if (this.b[n2] != keyId.b[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public int hashCode() {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.b.length) {
                n2 += this.b[n3];
                ++n3;
            }
            return n2;
        }
    }
}

