/********************************************************************
*
*  This library is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version.
*
*  This library is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; if not, write to the
*  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
*  Boston, MA  02111-1307, USA.
*
*  Based on EmbreoRun
*
*  @author: Copyright (C) Tim Carver
*
********************************************************************/


package org.emboss.jemboss.soap;

import java.io.*;
import java.util.*;

import org.emboss.jemboss.JembossParams;
import org.apache.soap.rpc.*;

public class JembossRun
{

  private String statusmsg;
  private String status;
  private Hashtable proganswer;

/**
*
* Executes an application on a server
* @param appl       String defining command
* @param options    String defining options
* @param filesToMove  Hashtable of filenames and contents
* @param mysettings JembossParams defining server parameters
* @throws JembossSoapException if authentication fails
*
*/
   public JembossRun(String appl, String options, Hashtable filesToMove, 
                    JembossParams mysettings) throws JembossSoapException 
{

     String fulloptions;

     Vector params = new Vector();
     params.addElement(new Parameter("appl", String.class,
                                    appl, null));

     //construct a full options string
     fulloptions = "mode="+mysettings.getCurrentMode()+" "+options;
//   if (mysettings.getUseX11()) 
//     fulloptions = "display="+mysettings.getX11display()+" "+fulloptions;
     
     params.addElement(new Parameter("options", String.class,
				     fulloptions, null));

     // just pass the hash
     params.addElement(new Parameter("filename", Hashtable.class,
				     filesToMove, null));

     PrivateRequest eRun;
     try 
     {
       eRun = new PrivateRequest(mysettings,
				       "run_prog", params);
     }
     catch (JembossSoapException e)
     {
       throw new JembossSoapException("Authentication Failed");
     }

     proganswer = eRun.getHash();
     status = proganswer.get("status").toString();
     statusmsg = proganswer.get("msg").toString();
     
     proganswer.remove("status");  // delete the status/msg
     proganswer.remove("msg");
   }


/**
*
* The status of the request
* @return String 0 for success
*
*/
  public String getStatus() 
  {
    return status;
  }
  
/**
*
* A status message
* @return string containing a status message. Or description of a error.
*
*/
  public String getStatusMsg() 
  {
    return statusmsg;
  }

/**
*
* @return Hashtable of filenames and their contents generated by
* running the application
*
*/
  public Hashtable hash() 
  {
    return proganswer;
  }

/**
*
* @return the elements of the results Hashtable
*
*/
  public Enumeration elements() 
  {
    return proganswer.elements();
  }

/**
*
* @return the keys of the results Hashtable
*
*/
  public Enumeration keys() 
  {
    return proganswer.keys();
  }

/**
*
* @param Object key into the results Hashtable
* @return Object element in the results Hashtable
*
*/
  public Object get(Object key) 
  {
    return proganswer.get(key);
  }

}

