"""

Constant for error handling

"""

from constants import EAContinue, EAAbort, EAIgnore, EARetry

# Insert different error messages in here. Format is [ErrorNumber, ErrorMessage, ErrorAction]

# EAContinue = Write message to the log and continue
#   EAIgnore = Don't write anything to the log and continue
#    EAAbort = Write to the log and quit
#    EARetry = Retry the operation

errormsgs = [
    
    [2, "no such file or directory", EAContinue],
    [5, "input/output error", EAAbort],
    [6, "device not configured", EAAbort],
    [13, "permission denied", EAIgnore],
    [13, "keine berechtigung", EAIgnore],
    [28, "no space left", EAAbort],
    [30, "read-only file system", EAAbort],
    [32, "broken pipe", EARetry],
    [39, "directory not empty", EAIgnore],
    [40, "too many levels of symbolic links", EAContinue], 
    [52, "network dropped connection on reset", EAAbort],
    [54, "connection reset by peer", EARetry],
    [57, "socket is not connected", EARetry],
    [60, "operation timed out", EAAbort],
    [62, "too many levels of symbolic links", EAContinue],
    [65, "no route to host", EAAbort],

    [101, "network is unreachable", EAAbort],
    [104, "connection reset by peer", EARetry],
    [110, "connection timed out", EARetry],
    [111, "connection refused", EAAbort],
    [113, "no route to host", EAAbort],
    [131, "connection reset by peer", EARetry],
    [150, "about to open data connection", EARetry],
    [150, "opening binary mode data connection", EAIgnore],

    [200, "data port set", EAIgnore],
    [200, "port command okay", EAIgnore],
    [200, "port command successful", EAIgnore],
    [200, "type is now 8-bit binary", EAIgnore],
    [200, "type set to a", EAIgnore],
    [200, "type set to i", EAIgnore],
    [200, "type okay", EAIgnore],
    [226, "nothing left to download", EAIgnore],
    [227, "entering passive Mode", EAIgnore],
    [250, "cwd command successful", EAIgnore],

    [421, "anything productive", EARetry],
    [421, "disconnecting you since you were inactive for", EARetry],
    [421, "timeout", EARetry],
    [425, "address already in use", EAAbort],
    [425, "can't assign requested address", EAAbort],
    [425, "can't build data connection", EAAbort],
    [425, "can't create data socket", EAAbort],
    [425, "can't open passive connection", EAAbort],
    [425, "connection refused", EAAbort],
    [425, "connection timed out", EARetry],
    [425, "failed to establish connection", EAAbort],
    [425, "interrupted system call", EAAbort],
    [425, "input/output error", EAAbort],
    [425, "network is unreachable", EAAbort],
    [425, "no route to host", EAAbort],
    [425, "no such device", EAAbort],
    [425, "open data connection", EAAbort],
    [425, "operation already in progress", EAAbort],
    [425, "operation not permitted", EAAbort],
    [425, "operation timed out", EARetry],
    [425, "resource temporarily unavailable", EAAbort],
    [425, "timeout on network transaction", EAAbort],
    [425, "too many open files", EAAbort],
    [426, "data connection: bad file descriptor", EAAbort],
    [426, "data connection: bad file number", EAAbort],
    [426, "data connection: broken pipe", EARetry],
    [426, "data connection: connection reset by peer", EAAbort],
    [426, "data connection: error 0", EAAbort],
    [426, "data connection: illegal seek", EAAbort],
    [426, "data connection: interrupted system call", EAAbort],
    [426, "data connection: no such file or directory", EAContinue],
    [426, "data connection: success", EAIgnore],
    [426, "data connection: transport endpoint is not connected", EAAbort],
    [426, "error writing to port", EAAbort],
    
    [500, "illegal port command", EAAbort],
    [500, "illegal port rejected", EAAbort],
    [500, "invalid port command", EAAbort],
    [500, "port argument must be", EAAbort],
    [500, "will not send to 3rd-party host", EAAbort],
    [501, "illegal port command", EAAbort],
    [502, "rest command not implemented", EAAbort],
    [502, "command not implemented", EAAbort],
    [504, "passive ftp port failled", EAAbort],
    [504, "reply marker must be 0", EAAbort],
    [530, "permission denied", EAContinue],
    [530, "no such file or directory", EAContinue],
    [550, "access denied", EAContinue],
    [550, "access is denied", EAContinue],
    [550, "address already in use", EAAbort],
    [550, "anonymous users when the load is that", EAAbort],
    [550, "been approved", EAIgnore],
    [550, "cannot connect to", EAAbort],
    [550, "connect failed", EAAbort],
    [550, "connection refused", EAAbort],
    [550, "does not exist", EAIgnore],
    [550, "drive not ready", EAAbort],
    [550, "error writing to port", EAAbort],
    [550, "failed to open file", EAIgnore],
    [550, "failed to change directory", EAIgnore],
    [550, "is marked unretrievable", EAIgnore],
    [550, "input/output error", EAAbort],
    [550, "no route to host", EAAbort],
    [550, "no such directory", EAContinue],
    [550, "no such file", EAContinue],
    [550, "no such file or directory", EAContinue],
    [550, "not a directory", EAContinue],
    [550, "not a plain file", EAContinue],
    [550, "not a regular file", EAContinue],
    [550, "operation would block", EAAbort],
    [550, "permission denied", EAContinue],
    [550, "resource temporarily unavailable", EAAbort],
    [550, "share.exe was not loaded, or a shared region was locked", EAAbort],
    [550, "sorry, i don't see that file", EAIgnore],
    [550, "the process cannot access the file", EAIgnore],
    [550, "the system cannot find the file specified", EAIgnore],
    [550, "timed out", EARetry],
    [550, "too many open files", EAAbort],
    [550, "unknown directory", EAAbort],
    [550, "was not loaded, or a shared region was locked", EAAbort],
    [551, "connection timed out", EARetry],
    [551, "error on input connection", EARetry],
    [551, "error on input file: input/output error", EARetry],
    [551, "error on input file: invalid argument", EAAbort],
    [551, "error on input file: no such file", EAIgnore],
    [551, "error on input file: operation timed out", EAAbort],
    [551, "error on input file: stale nfs file handle", EAAbort],
    [553, "no such file or directory", EAAbort],
    [553, "permission denied", EAAbort],

    [901, "ftplib internal: connection lost", EAAbort]
    
    ]

