"""

Constants necessary for EMirror, seperated into classes

"""

from re import compile

# Program Information (PI*)

PIVersion = "2.1.21"
PIHeader  = "\nECLiPt-Mirror Version " + PIVersion + " (c) 1998-2002 Martin Preishuber\n"
PIUsage   = "Usage: emirror [options] URL\n\n" + \
          "Mandatory arguments to long options are mandatory for short options too.\n"
PIOptions = "Startup:\n" + \
          "  -V, --version   display the version of ECLiPt Mirror and exit.\n" + \
          "  -h, --help      print this help.\n" + \
          "  -v, --verbose   be verbose.\n\n" + \
          "Logging, input and output files:\n" + \
          "  -o, --output-file=FILE             log messages to FILE.\n" + \
          "  -O, --output-directory=DIRECTORY   put logfiles into DIRECTORY.\n" + \
          "  -f, --output-format=FORMAT         set logfile format to FORMAT.\n" + \
          "  -c, --config-file=FILE             load configuration information from FILE.\n" + \
          "  -d, --config-directory=DIRECTORY   load configuration files from DIRECTORY.\n" + \
          "  -n, --index-directory=DIRECTORY    set index-file/log-file directory to DIR.\n" + \
          "      --category=TEXT                set category of the mirror to TEXT.\n" + \
          "      --description=TEXT             set description of the mirror to TEXT.\n" + \
          "      --title=TEXT                   set title for the mirror-log to TEXT.\n" + \
          "      --email=EMAIL                  set admin-email to EMAIL.\n" + \
          "      --log-template=FILE            template file for logfiles.\n" + \
          "      --index-template=FILE          template file for the index file.\n" + \
          "      --summary-template=FILE        template file for summary indizes.\n" + \
          "      --mail-user-cmd=COMMAND        command to send mail about changes.\n" + \
          "      --mail-users=FILE              mail info about changes to users in FILE.\n" + \
          "      --info-mailcmd=COMMAND         send mail to users when mirror changed.\n\n" + \
          "Download and FTP options:\n" + \
          "  -P, --parent=DIRECTORY         set parent directory for downloads to DIR.\n" + \
          "  -s, --parent-format=FORMAT     set parent directory format to FORMAT.\n" + \
          "  -D, --download-url=URL         set local download url to URL.\n" + \
          "  -t, --tries=NUMBER             set number of retries to NUMBER (0 unlimits).\n" + \
          "  -w, --wait=SECONDS             wait SECONDS between retries.\n" + \
          "  -r, --recursive                recursive download.\n" + \
          "  -F, --follow-symlinks          follow symbolic links.\n" + \
          "  -e, --exclude=REGEXP           set exclude pattern to REGEXP.\n" + \
          "  -i, --include=REGEXP           set include pattern to REGEXP.\n" + \
          "  -l, --only-latest              download only the latest file (matching -i).\n" + \
          "  -u, --username=TEXT            set username TEXT for downloads.\n" + \
          "  -p, --password=TEXT            set password TEXT for downloads.\n" + \
          "  -m, --max-parallel=NUMBER      set max. number of parallel downloads to NUM.\n" + \
          "  -R, --real-hostname=HOSTNAME   set real hostname to HOSTNAME (override URL).\n" + \
          "  -M, --max-days=NUMBER          set max. age of files to download to NUM. days.\n" + \
          "  -A, --max-age=NUMBER           set max. age of local files to NUMBER days.\n" + \
          "  -E, --max-delete=VALUE         delete max. VALUE files (KB, MB or percent).\n" + \
          "  -U, --umask=MASK               set the umask to MASK.\n" + \
          "      --ignore-mdtm              ignore mdtm when downloading files.\n" + \
          "      --owner=UID:GID            set the file owener to UID:GID.\n" + \
          "      --delete-local             always delete local files.\n" + \
          "      --passive                  set passive mode.\n" + \
          "      --continue                 restart getting an existing file.\n" + \
          "      --proxy=HOST:PORT          set proxy host and port.\n" + \
          "      --test                     set test mode (no real actions).\n\n" + \
          "Error handling options:\n" + \
          "      --error-mailcmd=COMMMAND   set error mailing command to COMMAND.\n\n" + \
          "Special debug options:\n" + \
          "      --debug                    debug mode (be very verbose).\n" + \
          "      --noexception              do not use exception handling.\n\n" + \
          "Advanced options:\n" + \
          "  -k, --no-kill             do not kill old processes.\n" + \
          "      --pid-file=FILENAME   set the pid-file to FILENAME.\n\n" + \
          "Please report any bugs/comments to Martin.Preishuber@eclipt.at\n"
PIRevLog = "Revision Log:\n\n" + \
         "    1.1b1 to b3      released as SimpleMirror in early 1998 \n" + \
         "    2.0b1 to b6      May - November 1998\n" + \
         "    2.0              February 9th, 1999\n" + \
         "    2.1pre2 to pre15 February 1999 - April 2000\n" + \
         "    2.1.16           August 21st, 2000\n" + \
         "    2.1.17           October 26th, 2000\n" + \
         "    2.1.18           April 18th, 2001\n" + \
         "    2.1.19           August 2nd, 2001\n" + \
         "    2.1.20           October 20th, 2001\n\n" + \
         "Have a look at the ChangeLog-file to get some more details.\n" + \
         "The most recent version can be found at:\n\n" + \
         "    http://www.eclipt.at   (Projects -> ECLiPt Mirroring Tool)\n" + \
         "    ftp://eclipt.uni-klu.ac.at/pub/projects/emirror\n\n" + \
         "Please report bugs, comments and feedback to Martin.Preishuber@eclipt.at\n"

# File Types (FT*)

FTDirectory = "Directory"
FTLink = "Link"
FTRegularFile = "Regular File"
FTLinkTarget = "LinkTarget"

# Log Messages (LM*)

LMError = "Error"
LMWarning = "Warning"
LMRetrieve = "Retrieve"
LMDelete = "Delete"
LMLink = "Link"

# Logfile Formats (LF*)

LFHTML = "html"
LFPlain = "plain"
LFPHP = "php"

# Logfile Extensions (LE*)

LEHTML = ".html"
LEPlain = ".txt"
LEPHP = ".php"

# Connection Types (CT*)

CTFTP = "ftp"
CTHTTP = "http"

# Connection Status

CSConnected = 1
CSDisconnected = 0

# Mirror status (MS*)

MSunchanged = "unchanged"
MSnotloggedin = "notloggedin"
MSunknown = "unknown"

# Default Values (DV*)

DVUsername = "ftp"
DVPassword = "emirror@"
DVRetries = 5
DVDelay = 30

# Parent Format (PF*)

PFFull = "full"
PFPath = "path"
PFNone = "none"

# Error Action (EA*)

EAContinue = "continue"
EAAbort = "abort"
EAIgnore = "ignore"
EARetry = "retry"

# Error Sources (ES*)

ESDownloadFile = "downloadfile"
ESGetRemoteFileListCwd = "getremotefilelist (cwd)"
ESGetRemoteFileListLS = "getremotefilelist (ls)"
ESDeleteFile = "DeleteFile"
ESGetLocalFileList = "GetLocalFileList"

# Installer constants (INS*)

INSBuildDir = "/var/tmp/"
INSRPMOpts = "-Uvh"
INSRPMBuildOpts = "--rebuild"
INSRPMDir = "/usr/src/redhat/RPMS"

# Miscellaneous constants

LastlogFilename = "lastlog.emirror"
EMirrorEnvironment = "EMIRRORCFGPATH"
EMirrorEnvOptions = "EMIRROROPTIONS"

MSDate = compile("\d\d-\d\d-\d\d")
MSMonthStrings = [ "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec" ]
