/* 
    These are the events that fam++ can raise. Also event handler adapters.

    Copyright (C) 2000 Ben Martin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
namespace __FAM_NAMESPACE {

	class FamppEvent {
		private:
		protected:
			friend class Fampp;
			friend class FamppRequest; // getFAMEvent

			virtual void handle() {}

			typedef int FamppFAMCodeType;
			virtual FamppFAMCodeType getFAMCode() {
				return -1;
			}

			FAMEvent* getFAMEvent() {
				return __PRIVATE_FAM_NAMESPACE::theFamppEventModel.getFAMEvent();
			}
		public:

			string getFileName() {
				return string(getFAMEvent()->filename);
			}

			/* event_name() - return printable name of fam event code */
			virtual const string getEventName() {
    			static string unknown_event;
       			unknown_event = "unknown code:" + getFAMEvent()->code;
       			return unknown_event;
			}
	};


	class FamppChangedEvent: public FamppEvent {
	public:
			virtual const string getEventName() {
				static string name = "FAMChanged";
				return name;
			}
			virtual FamppFAMCodeType getFAMCode() {
				return FAMChanged;
			}
	};


	class FamppDeletedEvent: public FamppEvent {
	public:
			virtual const string getEventName() {
				static string name = "FAMDeleted";
				return name;
			}
			virtual FamppFAMCodeType getFAMCode() {
				return FAMDeleted;
			}
	};

	class FamppStartExecutingEvent: public FamppEvent {
	public:
			virtual const string getEventName() {
				static string name = "FAMStartExecuting";
				return name;
			}
			virtual FamppFAMCodeType getFAMCode() {
				return FAMStartExecuting;
			}
	};

	class FamppStopExecutingEvent: public FamppEvent {
	public:
			virtual const string getEventName() {
				static string name = "FAMStopExecuting";
				return name;
			}
			virtual FamppFAMCodeType getFAMCode() {
				return FAMStopExecuting;
			}
	};

	class FamppCreatedEvent: public FamppEvent {
	public:
			virtual const string getEventName() {
				static string name = "FAMCreated";
				return name;
			}
			virtual FamppFAMCodeType getFAMCode() {
				return FAMCreated;
			}
	};

	class FamppMovedEvent: public FamppEvent {
	public:
			virtual const string getEventName() {
				static string name = "FAMMoved";
				return name;
			}
			virtual FamppFAMCodeType getFAMCode() {
				return FAMMoved;
			}
	};

	class FamppAcknowledgeEvent: public FamppEvent {
	public:
			virtual const string getEventName() {
				static string name = "FAMAcknowledge";
				return name;
			}
			virtual FamppFAMCodeType getFAMCode() {
				return FAMAcknowledge;
			}
	};

	class FamppExistsEvent: public FamppEvent {
	public:
			virtual const string getEventName() {
				static string name = "FAMExists";
				return name;
			}
			virtual FamppFAMCodeType getFAMCode() {
				return FAMExists;
			}
	};
	class FamppEndExistEvent: public FamppEvent {
	public:
			virtual const string getEventName() {
				static string name = "FAMEndExist";
				return name;
			}
			virtual FamppFAMCodeType getFAMCode() {
				return FAMEndExist;
			}
	};


/////////////
// Handlers
/////////////


	class abstractFamppEventHandler {
	protected:
	public:
		virtual void handle()=0;
	};

	template <class _Event>
	class FamppEventHandler: public abstractFamppEventHandler {
	protected:
		_Event ev;
		FamppEventHandler( _Event _ev ):
			ev(_ev)
		{}
	public:

		typedef _Event event_type;
		virtual void handle() {}
	};


	template <class _Function, class _Super, class _Event>
	class FamppEventHandlerAdaptor: public _Super {
			_Function func_Obj;

		virtual void handle() {
				func_Obj(ev); 
			}
	public:
		FamppEventHandlerAdaptor( 
			_Function _func_Obj,
			_Event _ev_Obj
		): 
			_Super(_ev_Obj),
			func_Obj(_func_Obj)
		{}
	};


/////////////////////




};



