
#ifndef __FAM_NAMESPACE
#define __FAM_NAMESPACE famppNS
#endif

//#include "fam.hh"

#include <gtk/gtk.h>
#include <gnome.h> // dubios.. used by error dialog.

namespace __FAM_NAMESPACE {

#ifndef DELAY_getInstance_gnome_and_wait	
#define DELAY_getInstance_gnome_and_wait 1000
#endif
	
	
	void Fampp_removeRequest(Fampp* fam, FamppRequest *req) {
		fam->FAMppRequestsByID[FAMREQUEST_GETREQNUM(
				(&req->getRequest()))] = 0;
	}

	#ifdef __GDK_H__
	gint
	fam_connect_callback (gpointer data)
	{
		Fampp_gdk** ts = (Fampp_gdk**)data;

		try {
			(*ts) = new Fampp_gdk();
			
			gtk_main_quit();
			return FALSE;
		}
		catch( ... ) {
		}
	
	return TRUE; // Call again.
	}

	FamppHandle<Fampp_gdk> bindInstance( Fampp_gdk* p ) {
		// Only create the handle if the new operation worked ok.
		static FamppHandle<Fampp_gdk> hs(p);
		return hs;			
	}
	
	FamppHandle<Fampp_gdk> getInstance_gnome_and_wait() {

		static Fampp_gdk* s = NULL;
		Fampp_gdk* ts = NULL;

		_TOP_OF__getInstance_gnome_and_wait:
		
		try {
			if( !s ) {
				ts = new Fampp_gdk();
			}
			return bindInstance(s = ts);
		}
		catch(FamppException e) {
			GtkWidget * mbox = NULL;
			guint timer_id = gtk_timeout_add (DELAY_getInstance_gnome_and_wait, fam_connect_callback, &ts);
			string famstr = e.getStdFAMError();
			string str = string("Error connecting to fam: ") + famstr;
			str += string("\nShould another attempt be made to connect");
			if(!mbox) {
				mbox = gnome_message_box_new (str.c_str(), 
					GNOME_MESSAGE_BOX_ERROR,
					GNOME_STOCK_BUTTON_YES, 
					GNOME_STOCK_BUTTON_NO, 
					NULL);
				gtk_widget_show (mbox);
			}
		  	int reply = gnome_dialog_run(GNOME_DIALOG(mbox));

			// They want a second chance.
  			if (reply == GNOME_YES) {
				goto _TOP_OF__getInstance_gnome_and_wait;
			}
			
			// Callback connected async for us?
			if(ts) {
				// Because the callback connected, the dialog box is still shown.
				// thus we must remove it from the display first.
				gtk_widget_destroy( mbox );
				return bindInstance(s = ts);
			}
			else {
				throw getInstance_gnome_and_wait_user_wants_to_quit();
			}
		}
	}
	#endif // ifdef __GDK_H__
};
