/* 
    This is the model for Fampp, the Model enables pass by value for Fampp.

    Copyright (C) 2000 Ben Martin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

namespace __PRIVATE_FAM_NAMESPACE {

	

	class FamppModel {


		FAMConnection theFAMConnection;

		private:
		FamppModel( const FamppModel& ref) {
		}
		FamppModel& operator=(const FamppModel& ref) {
			static FamppModel xref;
			return xref; // should never happen! only here to keep compiler happy.
		}

		public:
			FamppModel() {
				if( 0 != FAMOpen( &theFAMConnection )) {
					throw __FAM_NAMESPACE::FamppOpenFailedException();
				}
			}
			FamppModel(const string appName) {
				FamppModel( appName.c_str() );
			}

			~FamppModel() {
				if(0 != FAMClose( &theFAMConnection )) {
					throw __FAM_NAMESPACE::FamppCloseFailedException();
				}
			}

			int getFD() {
				return FAMCONNECTION_GETFD((&theFAMConnection));
			}

			FAMConnection* getFAMConnection() {
				return &theFAMConnection;
			}

	};


};



