/* 
    This is a simple console only application that monitors /tmp using fam++

    Copyright (C) 2000 Ben Martin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <fam.hh>
#include <famStatic.hh>
#include <iostream>

using namespace __FAM_NAMESPACE;


// 
// Fampp uses a model thus a deep copy of fam is ok. only one connection is created here.
//
void myFunc(Fampp fam) {

}


class myFileChangedHandler {
public:
	void operator()(FamppChangedEvent &ev) { 
		cout << "myFileChangedHandler: File that changed is: ";
		cout << ev.getFileName() << endl;
	}
};

class DelHandler {
public:

	void memberFunc(FamppDeletedEvent &ev) { 
		cout << "DelHandler::memberFunc: File that was deleted is: ";
		cout << ev.getFileName() << endl;
	}
};

class DelHandler2 {
public:

	void operator()(FamppDeletedEvent &ev) { 
		cout << "DelHandler2: File that was deleted is: ";
		cout << ev.getFileName() << endl;
	}
};


int main(int argc, char **argv) {

	cout<<"about to create a fam"<<endl;

	try {
		cout<<"about to create a fam instance"<<endl;
		Fampp fam;

		// harmless to pass Fampp by value.
		myFunc(fam);
	
		cout<<"about to create a request"<<endl;
		Handle<FamppRequest> req(fam.MonitorDirectory("/tmp"));

		cout << "setup a changed handler" << endl;
		req->setHandler(FamppChangedEvent(),myFileChangedHandler());
		req->setHandler(FamppDeletedEvent(),DelHandler2());
//		req->setHandler(FamppDeletedEvent(),&DelHandler::memberFunc);
		cout<<"about to NextEvent"<<endl;
		cout << "Change something in /tmp and look here"<< endl;
		while(true) {
			fam.NextEvent();
		}
	}
	catch(FamppOpenFailedException e) {
		cerr << "Failed to open fam" << endl;
	}
	catch(FamppMonitorInitFailedException e) {
		cerr << "Failed to tell fam to monitor the file" << endl;
	}
	catch(FamppNextEventFailedException e) {
		cerr << "Failed in NextEvent()" << endl;
	}
	catch(...) {
		cerr << " (...) error" << endl;
	}
}