/*
 * Decompiled with CFR 0.152.
 */
package FESI.AST;

import FESI.AST.EcmaScriptVisitor;
import FESI.AST.Node;
import FESI.AST.SimpleNode;
import FESI.Data.ESBoolean;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Exceptions.ProgrammingError;
import FESI.Parser.EcmaScript;

public class ASTLiteral
extends SimpleNode {
    private ESValue theValue;

    public ASTLiteral(int n) {
        super(n);
    }

    public ASTLiteral(EcmaScript ecmaScript, int n) {
        super(ecmaScript, n);
    }

    public static Node jjtCreate(int n) {
        return new ASTLiteral(n);
    }

    public static Node jjtCreate(EcmaScript ecmaScript, int n) {
        return new ASTLiteral(ecmaScript, n);
    }

    public Object jjtAccept(EcmaScriptVisitor ecmaScriptVisitor, Object object) {
        return ecmaScriptVisitor.visit(this, object);
    }

    public ESValue getValue() {
        return this.theValue;
    }

    static final int hexval(char c) throws ProgrammingError {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new ProgrammingError("Illegal hex or unicode constant");
    }

    static final int octval(char c) throws ProgrammingError {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new ProgrammingError("Illegal octal constant");
    }

    public void setStringValue(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.charAt(n2);
            if (n3 == 92 && n2 + 1 < n) {
                if ((n3 = string.charAt(++n2)) == 110) {
                    n3 = 10;
                } else if (n3 == 98) {
                    n3 = 8;
                } else if (n3 == 102) {
                    n3 = 12;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 120) {
                    n3 = (char)(ASTLiteral.hexval(string.charAt(n2 + 1)) << 4 | ASTLiteral.hexval(string.charAt(n2 + 1)));
                    n2 += 2;
                } else if (n3 == 117) {
                    n3 = (char)(ASTLiteral.hexval(string.charAt(n2 + 1)) << 12 | ASTLiteral.hexval(string.charAt(n2 + 2)) << 8 | ASTLiteral.hexval(string.charAt(n2 + 3)) << 4 | ASTLiteral.hexval(string.charAt(n2 + 4)));
                    n2 += 4;
                } else if (n3 >= 48 && n3 <= 55) {
                    n3 = (char)ASTLiteral.octval(string.charAt(n2));
                    if (string.length() > n2 && string.charAt(n2 + 1) >= '0' && string.charAt(n2 + 1) <= '7') {
                        n3 = (char)(n3 << 4 | ASTLiteral.octval(string.charAt(++n2)));
                    }
                }
            }
            stringBuffer.append((char)n3);
            ++n2;
        }
        this.theValue = new ESString(stringBuffer.toString());
    }

    public void setDecimalValue(String string) {
        try {
            this.theValue = new ESNumber(Long.parseLong(string));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            Double d = new Double(string);
            this.theValue = new ESNumber(d);
            return;
        }
    }

    public void setOctalValue(String string) {
        try {
            String string2 = string.substring(1);
            this.theValue = new ESNumber(Long.parseLong(string2, 8));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            Double d = new Double(string);
            this.theValue = new ESNumber(d);
            return;
        }
    }

    public void setHexValue(String string) {
        try {
            String string2 = string.substring(2);
            this.theValue = new ESNumber(Long.parseLong(string2, 16));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            Double d = new Double(string);
            this.theValue = new ESNumber(d);
            return;
        }
    }

    public void setFloatingPointValue(String string) {
        Double d = new Double(string);
        this.theValue = new ESNumber(d);
    }

    public void setBooleanValue(boolean bl) {
        this.theValue = ESBoolean.makeBoolean(bl);
    }

    public void setNullValue() {
        this.theValue = ESNull.theNull;
    }

    public String toString() {
        return "[" + this.theValue.toString() + "]";
    }
}

