/*
 * Decompiled with CFR 0.152.
 */
package FESI.ClassFile;

import FESI.ClassFile.Attribute;
import FESI.ClassFile.ClassConstant;
import FESI.ClassFile.ConstantPoolEntry;
import FESI.ClassFile.FieldConstant;
import FESI.ClassFile.FieldDesc;
import FESI.ClassFile.IntegerConstant;
import FESI.ClassFile.MethodConstant;
import FESI.ClassFile.MethodDesc;
import FESI.ClassFile.StringConstant;
import FESI.ClassFile.UTF8Constant;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

final class ClassFile {
    private static final int MAGIC = -889275714;
    private static final short MAJOR = 45;
    private static final short MINOR = 3;
    static final short ACC_PUBLIC = 1;
    static final short ACC_FINAL = 16;
    static final short ACC_SUPER = 32;
    static final short ACC_INTERFACE = 512;
    static final short ACC_ABSTRACT = 1024;
    private Vector constantPool = new Vector(1);
    private short accessFlags = (short)33;
    private ClassConstant thisClass;
    private ClassConstant superClass;
    private Vector interfaces;
    private Vector fields;
    private Vector methods;
    private Vector attributes;

    static boolean debug() {
        return false;
    }

    ClassFile(String string, String string2) {
        this.thisClass = this.addClassConstant(string);
        this.superClass = this.addClassConstant(string2);
    }

    private void writeConstantPool(DataOutputStream dataOutputStream) throws IOException {
        if (ClassFile.debug()) {
            System.err.println("write constant pool: " + this.constantPool.size());
        }
        dataOutputStream.writeShort(this.constantPool.size() + 1);
        int n = 0;
        while (n < this.constantPool.size()) {
            ((ConstantPoolEntry)this.constantPool.elementAt(n)).write(dataOutputStream);
            ++n;
        }
    }

    private void writeInterfaces(DataOutputStream dataOutputStream) throws IOException {
        if (this.interfaces != null) {
            if (ClassFile.debug()) {
                System.err.println("write interfaces: " + this.interfaces.size());
            }
            dataOutputStream.writeShort(this.interfaces.size());
            int n = 0;
            while (n < this.interfaces.size()) {
                dataOutputStream.writeShort(((ConstantPoolEntry)this.interfaces.elementAt(n)).getConstantPoolIndex());
                ++n;
            }
            return;
        }
        dataOutputStream.writeShort(0);
    }

    private void writeFields(DataOutputStream dataOutputStream) throws IOException {
        if (this.fields != null) {
            if (ClassFile.debug()) {
                System.err.println("write fields: " + this.fields.size());
            }
            dataOutputStream.writeShort(this.fields.size());
            int n = 0;
            while (n < this.fields.size()) {
                ((FieldDesc)this.fields.elementAt(n)).write(dataOutputStream);
                ++n;
            }
            return;
        }
        dataOutputStream.writeShort(0);
    }

    private void writeMethods(DataOutputStream dataOutputStream) throws IOException {
        if (this.methods != null) {
            if (ClassFile.debug()) {
                System.err.println("write methods: " + this.methods.size());
            }
            dataOutputStream.writeShort(this.methods.size());
            int n = 0;
            while (n < this.methods.size()) {
                ((MethodDesc)this.methods.elementAt(n)).write(dataOutputStream);
                ++n;
            }
            return;
        }
        dataOutputStream.writeShort(0);
    }

    private void writeAttributes(DataOutputStream dataOutputStream) throws IOException {
        if (this.attributes != null) {
            if (ClassFile.debug()) {
                System.err.println("write attributes: " + this.attributes.size());
            }
            dataOutputStream.writeShort(this.attributes.size());
            int n = 0;
            while (n < this.attributes.size()) {
                ((Attribute)this.attributes.elementAt(n)).write(dataOutputStream);
                ++n;
            }
            return;
        }
        dataOutputStream.writeShort(0);
    }

    public synchronized void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeInt(-889275714);
            dataOutputStream.writeShort(3);
            dataOutputStream.writeShort(45);
            this.writeConstantPool(dataOutputStream);
            if (ClassFile.debug()) {
                System.err.println("access: " + this.accessFlags);
            }
            dataOutputStream.writeShort(this.accessFlags);
            dataOutputStream.writeShort(this.thisClass.getConstantPoolIndex());
            dataOutputStream.writeShort(this.superClass.getConstantPoolIndex());
            this.writeInterfaces(dataOutputStream);
            this.writeFields(dataOutputStream);
            this.writeMethods(dataOutputStream);
            this.writeAttributes(dataOutputStream);
            dataOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println("Bad IO");
            return;
        }
        catch (Exception exception) {
            System.err.println("Oops");
            return;
        }
    }

    public synchronized short addConstantPoolEntry(ConstantPoolEntry constantPoolEntry) {
        if (!this.constantPool.contains(constantPoolEntry)) {
            this.constantPool.addElement(constantPoolEntry);
        }
        return (short)(this.constantPool.indexOf(constantPoolEntry) + 1);
    }

    synchronized ConstantPoolEntry match(byte by, Object object) {
        int n = 0;
        while (n < this.constantPool.size()) {
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)this.constantPool.elementAt(n);
            if (constantPoolEntry.getTag() == by && constantPoolEntry.equals(object)) {
                return constantPoolEntry;
            }
            ++n;
        }
        return null;
    }

    public synchronized short getAccessFlags() {
        return this.accessFlags;
    }

    public synchronized void setAccessFlags(short s) {
        this.accessFlags = s;
    }

    public synchronized void addMethodDesc(MethodDesc methodDesc) {
        if (this.methods == null) {
            this.methods = new Vector(1);
        }
        this.methods.addElement(methodDesc);
    }

    public synchronized void addFieldDesc(FieldDesc fieldDesc) {
        if (this.fields == null) {
            this.fields = new Vector(1);
        }
        this.fields.addElement(fieldDesc);
    }

    public StringConstant addStringConstant(String string) {
        UTF8Constant uTF8Constant = (UTF8Constant)this.match((byte)1, string);
        if (uTF8Constant == null) {
            uTF8Constant = new UTF8Constant(string, this);
        }
        StringConstant stringConstant = new StringConstant(uTF8Constant, this);
        return stringConstant;
    }

    public IntegerConstant addIntegerConstant(int n) {
        IntegerConstant integerConstant = (IntegerConstant)this.match((byte)3, new Integer(n));
        if (integerConstant == null) {
            integerConstant = new IntegerConstant(n, this);
        }
        return integerConstant;
    }

    public UTF8Constant addUTF8Constant(String string) {
        UTF8Constant uTF8Constant = (UTF8Constant)this.match((byte)1, string);
        if (uTF8Constant == null) {
            uTF8Constant = new UTF8Constant(string, this);
        }
        return uTF8Constant;
    }

    public ClassConstant addClassConstant(String string) {
        ClassConstant classConstant = (ClassConstant)this.match((byte)7, string);
        if (classConstant == null) {
            classConstant = new ClassConstant(string, this);
        }
        return classConstant;
    }

    public MethodConstant addMethodConstant(String string, String string2, String string3) {
        return new MethodConstant(string, string2, string3, this);
    }

    public FieldConstant addFieldConstant(String string, String string2, String string3) {
        return new FieldConstant(string, string2, string3, this);
    }

    public void addInterface(String string) {
        if (this.interfaces == null) {
            this.interfaces = new Vector(1);
        }
        this.interfaces.addElement(this.addClassConstant(string));
    }

    public static String fullyQualifiedForm(String string) {
        return string.replace('.', '/');
    }

    public static String fieldType(String string) {
        return "L" + ClassFile.fullyQualifiedForm(string) + ";";
    }
}

