/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DatePrototype
extends ESObject {
    protected Date date;

    DatePrototype(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator);
        this.date = new Date();
    }

    public DatePrototype(Evaluator evaluator, Date date) {
        super(evaluator.getDatePrototype(), evaluator);
        this.date = new Date(date.getTime());
    }

    public DatePrototype(Evaluator evaluator, long l) {
        super(evaluator.getDatePrototype(), evaluator);
        this.date = new Date(l);
    }

    public String getESClassName() {
        return "Date";
    }

    public ESValue setYear(ESValue[] eSValueArray) throws EcmaScriptException {
        if (this.date == null) {
            return new ESNumber(Double.NaN);
        }
        if (eSValueArray.length <= 0) {
            this.date = null;
            return new ESNumber(Double.NaN);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        gregorianCalendar.setTime(this.date);
        double d = eSValueArray[0].doubleValue();
        if (Double.isNaN(d)) {
            this.date = null;
            return new ESNumber(Double.NaN);
        }
        if (d < 100.0) {
            d += 1900.0;
        }
        gregorianCalendar.set(1, (int)d);
        this.date = gregorianCalendar.getTime();
        long l = this.date.getTime();
        return new ESNumber(l);
    }

    public ESValue setTime(ESValue[] eSValueArray, int[] nArray) throws EcmaScriptException {
        if (this.date == null) {
            return new ESNumber(Double.NaN);
        }
        if (eSValueArray.length <= 0) {
            this.date = null;
            return new ESNumber(Double.NaN);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        gregorianCalendar.setTime(this.date);
        int n = 0;
        while (n < nArray.length && n < eSValueArray.length) {
            double d = eSValueArray[n].doubleValue();
            if (Double.isNaN(d)) {
                this.date = null;
                return new ESNumber(Double.NaN);
            }
            gregorianCalendar.set(nArray[n], (int)d);
            ++n;
        }
        this.date = gregorianCalendar.getTime();
        long l = this.date.getTime();
        return new ESNumber(l);
    }

    public ESValue setUTCTime(ESValue[] eSValueArray, int[] nArray) throws EcmaScriptException {
        if (this.date == null) {
            return new ESNumber(Double.NaN);
        }
        if (eSValueArray.length <= 0) {
            this.date = null;
            return new ESNumber(Double.NaN);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.setTime(this.date);
        int n = 0;
        while (n < nArray.length && n < eSValueArray.length) {
            double d = eSValueArray[n].doubleValue();
            if (Double.isNaN(d)) {
                this.date = null;
                return new ESNumber(Double.NaN);
            }
            gregorianCalendar.set(nArray[n], (int)d);
            ++n;
        }
        this.date = gregorianCalendar.getTime();
        long l = this.date.getTime();
        return new ESNumber(l);
    }

    public ESValue get(int n) {
        if (this.date == null) {
            return new ESNumber(Double.NaN);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        gregorianCalendar.setTime(this.date);
        long l = gregorianCalendar.get(n);
        if (n == 7) {
            --l;
        }
        return new ESNumber(l);
    }

    public ESValue getUTC(int n) {
        if (this.date == null) {
            return new ESNumber(Double.NaN);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.setTime(this.date);
        long l = gregorianCalendar.get(n);
        if (n == 7) {
            --l;
        }
        return new ESNumber(l);
    }

    public String toString() {
        if (this.date == null) {
            return "null";
        }
        return this.date.toString();
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + (this.date == null ? "null" : this.date.toString()) + "]";
    }

    public Object toJavaObject() {
        return this.date;
    }

    public ESValue getDefaultValue() throws EcmaScriptException {
        return this.getDefaultValue(5);
    }
}

