/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESValue;
import FESI.Data.NumberPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;

public final class ESNumber
extends ESPrimitive {
    private double value;

    public ESNumber(double d) {
        this.value = d;
    }

    public int getTypeOf() {
        return 4;
    }

    public String getTypeofString() {
        return "number";
    }

    public boolean isNumberValue() {
        return true;
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean booleanValue() {
        return !Double.isNaN(this.value) && this.value != 0.0;
    }

    public String toString() {
        long l = (long)this.value;
        if ((double)l == this.value) {
            return Long.toString(l);
        }
        return Double.toString(this.value);
    }

    public ESValue toESObject(Evaluator evaluator) throws EcmaScriptException {
        NumberPrototype numberPrototype = null;
        ESObject eSObject = evaluator.getNumberPrototype();
        numberPrototype = new NumberPrototype(eSObject, evaluator);
        numberPrototype.value = this;
        return numberPrototype;
    }

    public ESValue toESNumber() {
        return this;
    }

    public Object toJavaObject() {
        long l = (long)this.value;
        Number number = null;
        number = (double)l == this.value ? (Number)((long)((byte)l) == l ? (Number)new Byte((byte)l) : (Number)((long)((short)l) == l ? (Number)new Short((short)l) : (Number)((long)((int)l) == l ? (Number)new Integer((int)l) : (Number)new Long(l)))) : (Number)new Double(this.value);
        return number;
    }

    public String toDetailString() {
        return "ES:#'" + Double.toString(this.value) + "'";
    }
}

