/*
 * Decompiled with CFR 0.152.
 */
package FESI.Exceptions;

import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.EvaluationSource;
import FESI.Parser.EcmaScriptConstants;
import FESI.Parser.ParseException;
import FESI.Parser.Token;

public class EcmaScriptParseException
extends EcmaScriptException
implements EcmaScriptConstants {
    private ParseException parseException;
    private EvaluationSource evaluationSource;
    private boolean canBeIncomplete = true;

    public EcmaScriptParseException(ParseException parseException, EvaluationSource evaluationSource) {
        super("Parsing error");
        this.parseException = parseException;
        this.evaluationSource = evaluationSource;
    }

    public int getLineNumber() {
        Token token = null;
        Token token2 = this.parseException.currentToken;
        if (token2 != null && token2.next != null) {
            token = token2.next;
        }
        if (token != null) {
            return token.beginLine;
        }
        return -1;
    }

    public boolean isIncomplete() {
        if (!this.canBeIncomplete) {
            return false;
        }
        Token token = this.parseException.currentToken;
        if (token != null && token.next != null) {
            token = token.next;
        }
        return token.kind == 0;
    }

    public void setNeverIncomplete() {
        this.canBeIncomplete = false;
    }

    public String getMessage() {
        String string;
        Token token = this.parseException.currentToken;
        Token token2 = null;
        if (token != null && token.kind == 53) {
            string = "Unterminated string constant near line " + token.beginLine + ", column " + token.beginColumn;
        } else {
            if (token != null && token.next != null) {
                token2 = token.next;
            }
            string = token2 != null & this.isForFutureExtension(token2.kind) ? "Keyword '" + token2.image + "' reserved for future extension near line " + token2.beginLine + ", column " + token2.beginColumn : "Syntax error detected near line " + token2.beginLine + ", column " + token2.beginColumn;
            if (token != null) {
                string = String.valueOf(string) + ", after " + this.parseException.tokenImage[token.kind];
            }
        }
        string = String.valueOf(string) + EcmaScriptException.eol + this.evaluationSource;
        return string;
    }

    private boolean isForFutureExtension(int n) {
        return n == 27 || n == 28 || n == 29 || n == 30 || n == 31 || n == 32 || n == 33 || n == 34 || n == 35 || n == 36 || n == 37 || n == 38 || n == 39 || n == 40 || n == 41 || n == 42;
    }
}

