/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ArrayPrototype;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.DatePrototype;
import FESI.Data.ESBoolean;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESFile;
import FESI.Extensions.ESStdFile;
import FESI.Extensions.Extension;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;
import java.io.File;

public class FileIO
extends Extension {
    private Evaluator evaluator;
    private ESObject esFilePrototype;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject globalObject = evaluator.getGlobalObject();
        ObjectPrototype objectPrototype = (ObjectPrototype)evaluator.getObjectPrototype();
        this.esFilePrototype = new ObjectPrototype(objectPrototype, evaluator);
        FunctionPrototype functionPrototype = (FunctionPrototype)evaluator.getFunctionPrototype();
        GlobalObjectFile globalObjectFile = new GlobalObjectFile("File", evaluator, functionPrototype);
        ESStdFile eSStdFile = new ESStdFile(this.esFilePrototype, evaluator, "<stdin>", System.in);
        ESStdFile eSStdFile2 = new ESStdFile(this.esFilePrototype, evaluator, "<stdout>", System.out);
        ESStdFile eSStdFile3 = new ESStdFile(this.esFilePrototype, evaluator, "<stderr>", System.err);
        this.esFilePrototype.putHiddenProperty("open", new FileOpen("open", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("flush", new FileFlush("flush", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("close", new FileClose("close", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("exists", new FileExists("exists", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("isFile", new FileIsFile("isFile", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("isOpened", new FileIsOpened("isOpened", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("isAbsolute", new FileIsAbsolute("isAbsolute", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("isDirectory", new FileIsDirectory("isDirectory", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("eof", new FileEof("eof", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("write", new FileWrite("write", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("writeln", new FileWriteln("writeln", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("readln", new FileReadln("readln", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("error", new FileError("error", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("clearError", new FileClearError("clearError", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("getLength", new FileGetLength("getLength", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("lastModified", new FileLastModified("lastModified", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("remove", new FileRemove("remove", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("renameTo", new FileRenameTo("renameTo", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("canWrite", new FileCanWrite("canWrite", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("canRead", new FileCanRead("canRead", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("getParent", new FileGetParent("getParent", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("getName", new FileGetName("getName", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("getPath", new FileGetPath("getPath", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("toString", new FileGetPath("toString", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("getAbsolutePath", new FileGetAbsolutePath("getAbsolutePath", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("mkdir", new FileMkdir("mkdir", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("list", new FileList("list", evaluator, functionPrototype));
        this.esFilePrototype.putHiddenProperty("readAll", new FileReadAll("readAll", evaluator, functionPrototype));
        globalObjectFile.putHiddenProperty("stdin", eSStdFile);
        globalObjectFile.putHiddenProperty("stdout", eSStdFile2);
        globalObjectFile.putHiddenProperty("stderr", eSStdFile3);
        globalObject.putHiddenProperty("File", globalObjectFile);
    }

    class GlobalObjectFile
    extends BuiltinFunctionObject {
        GlobalObjectFile(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            return this.doConstruct(eSObject, eSValueArray);
        }

        public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = null;
            if (eSValueArray.length == 0) {
                throw new EcmaScriptException("File requires 1 or 2 arguments");
            }
            if (eSValueArray.length == 1) {
                eSFile = new ESFile(FileIO.this.esFilePrototype, this.evaluator, eSValueArray[0].toString());
            } else if (eSValueArray.length > 1) {
                eSFile = new ESFile(FileIO.this.esFilePrototype, this.evaluator, eSValueArray[0].toString(), eSValueArray[1].toString());
            }
            return eSFile;
        }

        public ESValue getPropertyInScope(String string, ScopeChain scopeChain, int n) throws EcmaScriptException {
            if (string.equals("separator")) {
                return new ESString(File.separator);
            }
            return super.getPropertyInScope(string, scopeChain, n);
        }

        public ESValue getProperty(String string, int n) throws EcmaScriptException {
            if (string.equals("separator")) {
                return new ESString(File.separator);
            }
            return super.getProperty(string, n);
        }

        public String[] getSpecialPropertyNames() {
            String[] stringArray = new String[]{"separator"};
            return stringArray;
        }
    }

    class FileWriteln
    extends BuiltinFunctionObject {
        FileWriteln(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.write(true, eSValueArray));
        }
    }

    class FileReadln
    extends BuiltinFunctionObject {
        FileReadln(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            String string = eSFile.readln();
            if (string == null) {
                return ESNull.theNull;
            }
            return new ESString(string);
        }
    }

    class FileEof
    extends BuiltinFunctionObject {
        FileEof(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.eof());
        }
    }

    class FileExists
    extends BuiltinFunctionObject {
        FileExists(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.exists());
        }
    }

    class FileIsOpened
    extends BuiltinFunctionObject {
        FileIsOpened(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.isOpened());
        }
    }

    class FileIsAbsolute
    extends BuiltinFunctionObject {
        FileIsAbsolute(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.isAbsolute());
        }
    }

    class FileIsFile
    extends BuiltinFunctionObject {
        FileIsFile(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.isFile());
        }
    }

    class FileIsDirectory
    extends BuiltinFunctionObject {
        FileIsDirectory(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.isDirectory());
        }
    }

    class FileWrite
    extends BuiltinFunctionObject {
        FileWrite(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.write(false, eSValueArray));
        }
    }

    class FileOpen
    extends BuiltinFunctionObject {
        FileOpen(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.open());
        }
    }

    class FileClose
    extends BuiltinFunctionObject {
        FileClose(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.close());
        }
    }

    class FileFlush
    extends BuiltinFunctionObject {
        FileFlush(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.flush());
        }
    }

    class FileGetLength
    extends BuiltinFunctionObject {
        FileGetLength(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return new ESNumber(eSFile.getLength());
        }
    }

    class FileLastModified
    extends BuiltinFunctionObject {
        FileLastModified(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            long l = eSFile.lastModified();
            DatePrototype datePrototype = new DatePrototype(this.evaluator, l);
            return datePrototype;
        }
    }

    class FileError
    extends BuiltinFunctionObject {
        FileError(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return new ESString(eSFile.error());
        }
    }

    class FileClearError
    extends BuiltinFunctionObject {
        FileClearError(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            eSFile.clearError();
            return ESUndefined.theUndefined;
        }
    }

    class FileRemove
    extends BuiltinFunctionObject {
        FileRemove(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.remove());
        }
    }

    class FileRenameTo
    extends BuiltinFunctionObject {
        FileRenameTo(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            if (eSValueArray.length <= 0) {
                return ESBoolean.makeBoolean(false);
            }
            ESFile eSFile2 = null;
            eSFile2 = eSValueArray[0] instanceof ESFile ? (ESFile)eSValueArray[0] : new ESFile(FileIO.this.esFilePrototype, this.evaluator, eSValueArray[0].toString());
            return ESBoolean.makeBoolean(eSFile.renameTo(eSFile2));
        }
    }

    class FileCanWrite
    extends BuiltinFunctionObject {
        FileCanWrite(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.canWrite());
        }
    }

    class FileCanRead
    extends BuiltinFunctionObject {
        FileCanRead(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.canRead());
        }
    }

    class FileGetName
    extends BuiltinFunctionObject {
        FileGetName(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return new ESString(eSFile.getName());
        }
    }

    class FileGetParent
    extends BuiltinFunctionObject {
        FileGetParent(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return new ESString(eSFile.getParent());
        }
    }

    class FileGetPath
    extends BuiltinFunctionObject {
        FileGetPath(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return new ESString(eSFile.getPath());
        }
    }

    class FileGetAbsolutePath
    extends BuiltinFunctionObject {
        FileGetAbsolutePath(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return new ESString(eSFile.getAbsolutePath());
        }
    }

    class FileMkdir
    extends BuiltinFunctionObject {
        FileMkdir(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return ESBoolean.makeBoolean(eSFile.mkdir());
        }
    }

    class FileList
    extends BuiltinFunctionObject {
        FileList(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            String[] stringArray = eSFile.list();
            if (stringArray == null) {
                return ESBoolean.makeBoolean(false);
            }
            ESObject eSObject2 = this.evaluator.getArrayPrototype();
            ArrayPrototype arrayPrototype = new ArrayPrototype(eSObject2, this.evaluator);
            arrayPrototype.setSize(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                arrayPrototype.setElementAt(new ESString(stringArray[n]), n);
                ++n;
            }
            return arrayPrototype;
        }
    }

    class FileReadAll
    extends BuiltinFunctionObject {
        FileReadAll(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            FileIO.this = FileIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESFile eSFile = (ESFile)eSObject;
            return new ESString(eSFile.readAll());
        }
    }
}

