/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.AST.ASTAllocationExpression;
import FESI.AST.ASTAndExpressionSequence;
import FESI.AST.ASTAssignmentExpression;
import FESI.AST.ASTBinaryExpressionSequence;
import FESI.AST.ASTBreakStatement;
import FESI.AST.ASTCompositeReference;
import FESI.AST.ASTConditionalExpression;
import FESI.AST.ASTContinueStatement;
import FESI.AST.ASTEmptyExpression;
import FESI.AST.ASTExpressionList;
import FESI.AST.ASTForInStatement;
import FESI.AST.ASTForStatement;
import FESI.AST.ASTForVarInStatement;
import FESI.AST.ASTForVarStatement;
import FESI.AST.ASTFormalParameterList;
import FESI.AST.ASTFunctionCallParameters;
import FESI.AST.ASTFunctionDeclaration;
import FESI.AST.ASTIdentifier;
import FESI.AST.ASTIfStatement;
import FESI.AST.ASTLiteral;
import FESI.AST.ASTOperator;
import FESI.AST.ASTOrExpressionSequence;
import FESI.AST.ASTPostfixExpression;
import FESI.AST.ASTProgram;
import FESI.AST.ASTPropertyIdentifierReference;
import FESI.AST.ASTPropertyValueReference;
import FESI.AST.ASTReturnStatement;
import FESI.AST.ASTStatement;
import FESI.AST.ASTStatementList;
import FESI.AST.ASTThisReference;
import FESI.AST.ASTUnaryExpression;
import FESI.AST.ASTVariableDeclaration;
import FESI.AST.ASTWhileStatement;
import FESI.AST.ASTWithStatement;
import FESI.AST.EcmaScriptVisitor;
import FESI.AST.SimpleNode;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.EvaluationSource;
import FESI.Interpreter.Evaluator;
import FESI.Parser.EcmaScriptConstants;
import java.util.Vector;

public class EcmaScriptVariableVisitor
implements EcmaScriptVisitor,
EcmaScriptConstants {
    private Evaluator evaluator;
    private boolean debug = false;
    private Vector variableList;

    public EcmaScriptVariableVisitor(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public Vector processVariableDeclarations(ASTProgram aSTProgram, EvaluationSource evaluationSource) {
        if (this.debug) {
            System.out.println("processVariableDeclarations for program: " + aSTProgram);
        }
        this.variableList = new Vector();
        aSTProgram.jjtAccept(this, evaluationSource);
        return this.variableList;
    }

    public Vector processVariableDeclarations(ASTStatementList aSTStatementList, EvaluationSource evaluationSource) {
        if (this.debug) {
            System.out.println("processVariableDeclarations for function body: " + aSTStatementList);
        }
        this.variableList = new Vector();
        aSTStatementList.jjtAccept(this, evaluationSource);
        return this.variableList;
    }

    private void badAST() {
        throw new ProgrammingError("Bad AST walk in EcmaScriptVariableVisitor");
    }

    public Object visit(SimpleNode simpleNode, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTProgram aSTProgram, Object object) {
        object = aSTProgram.childrenAccept(this, object);
        return object;
    }

    public Object visit(ASTStatementList aSTStatementList, Object object) {
        object = aSTStatementList.childrenAccept(this, object);
        return object;
    }

    public Object visit(ASTFunctionDeclaration aSTFunctionDeclaration, Object object) {
        return object;
    }

    public Object visit(ASTFormalParameterList aSTFormalParameterList, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTStatement aSTStatement, Object object) {
        object = aSTStatement.childrenAccept(this, object);
        return object;
    }

    public Object visit(ASTVariableDeclaration aSTVariableDeclaration, Object object) {
        int n = aSTVariableDeclaration.jjtGetNumChildren();
        if (n < 1 || n > 2) {
            throw new ProgrammingError("Bad AST in variable declaration");
        }
        ASTIdentifier aSTIdentifier = (ASTIdentifier)aSTVariableDeclaration.jjtGetChild(0);
        if (this.debug) {
            System.out.println("VAR DECL: " + aSTIdentifier.getName());
        }
        this.variableList.addElement(aSTIdentifier.getName());
        return object;
    }

    public Object visit(ASTIfStatement aSTIfStatement, Object object) {
        object = aSTIfStatement.childrenAccept(this, object);
        return object;
    }

    public Object visit(ASTContinueStatement aSTContinueStatement, Object object) {
        return object;
    }

    public Object visit(ASTWhileStatement aSTWhileStatement, Object object) {
        object = aSTWhileStatement.childrenAccept(this, object);
        return object;
    }

    public Object visit(ASTForStatement aSTForStatement, Object object) {
        object = aSTForStatement.childrenAccept(this, object);
        return object;
    }

    public Object visit(ASTForInStatement aSTForInStatement, Object object) {
        object = aSTForInStatement.childrenAccept(this, object);
        return object;
    }

    public Object visit(ASTForVarStatement aSTForVarStatement, Object object) {
        object = aSTForVarStatement.childrenAccept(this, object);
        return object;
    }

    public Object visit(ASTForVarInStatement aSTForVarInStatement, Object object) {
        object = aSTForVarInStatement.childrenAccept(this, object);
        return object;
    }

    public Object visit(ASTBreakStatement aSTBreakStatement, Object object) {
        return object;
    }

    public Object visit(ASTReturnStatement aSTReturnStatement, Object object) {
        return object;
    }

    public Object visit(ASTWithStatement aSTWithStatement, Object object) {
        aSTWithStatement.setEvaluationSource(object);
        object = aSTWithStatement.childrenAccept(this, object);
        return object;
    }

    public Object visit(ASTThisReference aSTThisReference, Object object) {
        return object;
    }

    public Object visit(ASTCompositeReference aSTCompositeReference, Object object) {
        return object;
    }

    public Object visit(ASTFunctionCallParameters aSTFunctionCallParameters, Object object) {
        return object;
    }

    public Object visit(ASTPropertyValueReference aSTPropertyValueReference, Object object) {
        return object;
    }

    public Object visit(ASTPropertyIdentifierReference aSTPropertyIdentifierReference, Object object) {
        return object;
    }

    public Object visit(ASTAllocationExpression aSTAllocationExpression, Object object) {
        return object;
    }

    public Object visit(ASTOperator aSTOperator, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTPostfixExpression aSTPostfixExpression, Object object) {
        return object;
    }

    public Object visit(ASTUnaryExpression aSTUnaryExpression, Object object) {
        return object;
    }

    public Object visit(ASTBinaryExpressionSequence aSTBinaryExpressionSequence, Object object) {
        return object;
    }

    public Object visit(ASTAndExpressionSequence aSTAndExpressionSequence, Object object) {
        return object;
    }

    public Object visit(ASTOrExpressionSequence aSTOrExpressionSequence, Object object) {
        return object;
    }

    public Object visit(ASTConditionalExpression aSTConditionalExpression, Object object) {
        return object;
    }

    public Object visit(ASTAssignmentExpression aSTAssignmentExpression, Object object) {
        return object;
    }

    public Object visit(ASTExpressionList aSTExpressionList, Object object) {
        return object;
    }

    public Object visit(ASTEmptyExpression aSTEmptyExpression, Object object) {
        return object;
    }

    public Object visit(ASTLiteral aSTLiteral, Object object) {
        return object;
    }

    public Object visit(ASTIdentifier aSTIdentifier, Object object) {
        return object;
    }
}

