/*
 * Decompiled with CFR 0.152.
 */
import FESI.jslib.JSException;
import com.oroinc.net.ftp.FTPClient;
import com.oroinc.net.ftp.FTPFile;
import com.oroinc.net.ftp.FTPReply;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FTPModel {
    private String eol = System.getProperty("line.separator", "\n");
    private String server;
    private String username;
    private String password;
    private FTPClient ftp = new FTPClient();
    private int currentMode = 0;
    private LocalContext localContext;
    private boolean directoryByName = true;
    protected String lastError;
    protected String lastReply;
    private boolean exceptionMode = false;

    public boolean changeExceptionMode(boolean bl) {
        boolean bl2 = this.exceptionMode;
        this.exceptionMode = bl;
        return bl2;
    }

    public void setExceptionMode(boolean bl) {
        this.exceptionMode = bl;
    }

    protected boolean getExceptionMode() {
        return this.exceptionMode;
    }

    public boolean isConnected() {
        return this.ftp != null & this.ftp.isConnected();
    }

    public String getLastReply() {
        if (this.lastReply == null) {
            return "";
        }
        return this.lastReply;
    }

    public String getLastError() {
        return this.lastError;
    }

    public String getServer() {
        return this.server;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public FTPModel() {
        try {
            this.localContext = new LocalContext();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(-1);
            return;
        }
    }

    private void appendReplyStrings(String string) {
        if (this.lastReply == null) {
            this.lastReply = new String();
        }
        if (string != null && string.length() > 0) {
            this.lastReply = String.valueOf(this.lastReply) + string + this.eol;
        }
        String[] stringArray = this.ftp.getReplyStrings();
        int n = 0;
        while (n < stringArray.length) {
            this.lastReply = String.valueOf(this.lastReply) + stringArray[n] + this.eol;
            ++n;
        }
    }

    public boolean connect(String string, String string2, String string3) throws JSException {
        block8: {
            this.lastError = null;
            this.lastReply = null;
            if (this.isConnected()) {
                return this.returnErrorFalse("Already connect");
            }
            this.server = string.trim();
            this.username = string2.trim();
            this.password = string3.trim();
            try {
                this.ftp.connect(this.server);
                this.appendReplyStrings("Connection message:");
                int n = this.ftp.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)n)) {
                    this.ftp.disconnect();
                    return this.returnErrorFalse("FTP server refused connection:" + this.ftp.getReplyString());
                }
                if (!this.isConnected()) break block8;
                if (this.ftp.login(this.username, this.password)) {
                    this.appendReplyStrings("Login '" + this.username + "' ok to '" + this.server + "':");
                    break block8;
                }
                String string4 = "Login error:" + this.ftp.getReplyString();
                this.ftp.disconnect();
                return this.returnErrorFalse(string4);
            }
            catch (IOException iOException) {
                if (this.ftp.isConnected()) {
                    try {
                        this.ftp.disconnect();
                    }
                    catch (IOException iOException2) {}
                }
                return this.returnErrorFalse(iOException);
            }
        }
        return true;
    }

    public boolean disconnect() throws JSException {
        this.lastError = null;
        this.lastReply = null;
        if (this.isConnected()) {
            if (this.ftp.isConnected()) {
                try {
                    this.ftp.quit();
                    this.appendReplyStrings("Disconnected:");
                    this.ftp.disconnect();
                }
                catch (IOException iOException) {}
            }
            return true;
        }
        return this.returnErrorFalse("Not connected");
    }

    public String remoteGetWorkingDirectory() throws JSException {
        this.lastError = null;
        this.lastReply = null;
        if (this.isConnected()) {
            try {
                String string = this.ftp.printWorkingDirectory();
                if (string == null) {
                    return this.returnErrorNull("Cannot get remote working directory: " + this.ftp.getReplyString());
                }
                return string;
            }
            catch (IOException iOException) {
                return this.returnErrorNull("Error when getting current remote directory: " + this.eol + iOException.toString() + this.eol);
            }
        }
        return this.returnErrorNull("Not connected");
    }

    public boolean remoteChangeWorkingDirectory(String string) throws JSException {
        this.lastError = null;
        this.lastReply = null;
        if (this.isConnected()) {
            try {
                boolean bl = this.ftp.changeWorkingDirectory(string);
                if (bl) {
                    return true;
                }
                return this.returnErrorFalse("Remote change working directory to '" + string + "', error: " + this.ftp.getReplyString());
            }
            catch (IOException iOException) {
                return this.returnErrorFalse("Error changing remote working directory: " + this.eol + iOException.toString() + this.eol);
            }
        }
        return this.returnErrorFalse("Not connected");
    }

    public boolean remoteChangeToParentDirectory() throws JSException {
        this.lastError = null;
        this.lastReply = null;
        if (this.isConnected()) {
            try {
                boolean bl = this.ftp.changeToParentDirectory();
                if (bl) {
                    return true;
                }
                return this.returnErrorFalse("Remote change remote to parent directory error: " + this.ftp.getReplyString());
            }
            catch (IOException iOException) {
                return this.returnErrorFalse("Error changing to parent directory: " + this.eol + iOException.toString() + this.eol);
            }
        }
        return this.returnErrorFalse("Not connected");
    }

    public FTPFile[] remoteGetFileList() throws JSException {
        this.lastError = null;
        this.lastReply = null;
        FTPFile[] fTPFileArray = null;
        if (this.isConnected()) {
            try {
                if (this.directoryByName) {
                    fTPFileArray = this.ftp.listFiles();
                    if (fTPFileArray == null) {
                        fTPFileArray = new FTPFile[]{};
                    }
                } else {
                    String[] stringArray = this.ftp.listNames();
                    if (stringArray == null) {
                        fTPFileArray = new FTPFile[]{};
                    } else {
                        fTPFileArray = new FTPFile[stringArray.length];
                        int n = 0;
                        while (n < stringArray.length) {
                            FTPFile fTPFile = new FTPFile();
                            fTPFile.setName(stringArray[n]);
                            fTPFile.setRawListing(stringArray[n]);
                            fTPFileArray[n] = fTPFile;
                            ++n;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                this.lastError = "Error listing files:" + this.eol + iOException.toString() + this.eol;
            }
        } else {
            this.lastError = "Not connected";
        }
        if (fTPFileArray == null) {
            this.checkExceptionMode();
        }
        return fTPFileArray;
    }

    public boolean remoteMakeDirectory(String string) throws JSException {
        this.lastError = null;
        this.lastReply = null;
        if (this.isConnected()) {
            try {
                boolean bl = this.ftp.makeDirectory(string);
                if (bl) {
                    return true;
                }
                this.lastError = "Make remote directory '" + string + "' rejected: " + this.ftp.getReplyString();
            }
            catch (IOException iOException) {
                this.lastError = "Error making remote directory: " + this.eol + iOException.toString() + this.eol;
            }
        } else {
            this.lastError = "Not connected";
        }
        return this.returnErrorFalse();
    }

    public boolean remoteRenameFile(String string, String string2) throws JSException {
        this.lastError = null;
        this.lastReply = null;
        if (this.isConnected()) {
            try {
                boolean bl = this.ftp.rename(string, string2);
                if (bl) {
                    return true;
                }
                this.lastError = "Rename remote file '" + string + "' to '" + string2 + "' rejected: " + this.ftp.getReplyString();
            }
            catch (IOException iOException) {
                this.lastError = "Error renaming remote file: " + this.eol + iOException.toString() + this.eol;
            }
        } else {
            this.lastError = "Not connected";
        }
        return this.returnErrorFalse();
    }

    public boolean remoteDeleteFile(String string) throws JSException {
        this.lastError = null;
        this.lastReply = null;
        if (this.isConnected()) {
            try {
                boolean bl = this.ftp.deleteFile(string);
                if (bl) {
                    return true;
                }
                this.lastError = "Delete remote file '" + string + "' rejected: " + this.ftp.getReplyString();
            }
            catch (IOException iOException) {
                this.lastError = "Error deleting remote file: " + this.eol + iOException.toString() + this.eol;
            }
        } else {
            this.lastError = "Not connected";
        }
        return this.returnErrorFalse();
    }

    public boolean remoteRemoveDirectory(String string) throws JSException {
        this.lastError = null;
        this.lastReply = null;
        if (this.isConnected()) {
            try {
                boolean bl = this.ftp.removeDirectory(string);
                if (bl) {
                    return true;
                }
                this.lastError = "Remove remote directory '" + string + "' rejected: " + this.ftp.getReplyString();
            }
            catch (IOException iOException) {
                this.lastError = "Error removing remote directory: " + this.eol + iOException.toString() + this.eol;
            }
        } else {
            this.lastError = "Not connected";
        }
        return this.returnErrorFalse();
    }

    public String localGetWorkingDirectory() throws JSException {
        this.lastError = null;
        this.lastReply = null;
        return this.localContext.getCurrentWorkingDirectory();
    }

    public String localChangeWorkingDirectory(String string) throws JSException {
        this.lastError = null;
        this.lastReply = null;
        try {
            boolean bl = this.localContext.changeWorkingDirectory(string);
            if (bl) {
                return this.localContext.getCurrentWorkingDirectory();
            }
            return this.returnErrorNull("Change to local directory '" + string + "' rejected");
        }
        catch (IOException iOException) {
            return this.returnErrorNull("Error chaning local woring directory: " + this.eol + iOException.toString() + this.eol);
        }
    }

    public String localChangeToParentDirectory() throws JSException {
        this.lastError = null;
        this.lastReply = null;
        try {
            boolean bl = this.localContext.changeToParentDirectory();
            if (bl) {
                return this.localContext.getCurrentWorkingDirectory();
            }
            return this.returnErrorNull("Change to local parent directory rejected");
        }
        catch (IOException iOException) {
            return this.returnErrorNull("Error changing to local parent directory: " + this.eol + iOException.toString() + this.eol);
        }
    }

    public FTPFile[] localGetFileList() throws JSException {
        this.lastError = null;
        this.lastReply = null;
        FTPFile[] fTPFileArray = null;
        try {
            fTPFileArray = this.localContext.listFiles();
            if (fTPFileArray == null) {
                fTPFileArray = new FTPFile[]{};
            }
        }
        catch (IOException iOException) {
            this.lastError = "Error listing local files: " + this.eol + iOException.toString() + this.eol;
        }
        if (fTPFileArray == null) {
            this.checkExceptionMode();
        }
        return fTPFileArray;
    }

    public boolean localMakeDirectory(String string) throws JSException {
        this.lastError = null;
        this.lastReply = null;
        try {
            boolean bl = this.localContext.makeDirectory(string);
            if (bl) {
                return true;
            }
            this.lastError = "Make local directory '" + string + "' rejected";
        }
        catch (IOException iOException) {
            this.lastError = "Error making local directory: " + this.eol + iOException.toString() + this.eol;
        }
        return this.returnErrorFalse();
    }

    public boolean localRenameFile(String string, String string2) throws JSException {
        this.lastError = null;
        this.lastReply = null;
        try {
            boolean bl = this.localContext.renameFile(string, string2);
            if (bl) {
                return true;
            }
            this.lastError = "Rename local file '" + string + "' to ' " + string2 + "' rejected";
        }
        catch (IOException iOException) {
            this.lastError = "Error renaming local file: " + this.eol + iOException.toString() + this.eol;
        }
        return this.returnErrorFalse();
    }

    public boolean localDeleteFile(String string) throws JSException {
        this.lastError = null;
        this.lastReply = null;
        try {
            boolean bl = this.localContext.deleteFile(string);
            if (bl) {
                return true;
            }
            this.lastError = "Delete local file '" + string + "' rejected";
        }
        catch (IOException iOException) {
            this.lastError = "Error deleting local file: " + this.eol + iOException.toString() + this.eol;
        }
        return this.returnErrorFalse();
    }

    public boolean localRemoveDirectory(String string) throws JSException {
        this.lastError = null;
        this.lastReply = null;
        try {
            boolean bl = this.localContext.removeDirectory(string);
            if (bl) {
                return true;
            }
            this.lastError = "Remove local directory '" + string + "' rejected";
        }
        catch (IOException iOException) {
            this.lastError = "Removing deleting local directory: " + this.eol + iOException.toString() + this.eol;
        }
        return this.returnErrorFalse();
    }

    public boolean getTextFile(String string) throws JSException {
        return this.getFile(0, string, string);
    }

    public boolean getTextFile(String string, String string2) throws JSException {
        return this.getFile(0, string, string2);
    }

    public boolean getBinaryFile(String string) throws JSException {
        return this.getFile(2, string, string);
    }

    public boolean getBinaryFile(String string, String string2) throws JSException {
        return this.getFile(2, string, string2);
    }

    protected boolean getFile(int n, String string, String string2) throws JSException {
        if (this.isConnected()) {
            if (!this.checkMode(n)) {
                return this.returnErrorFalse();
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(this.localContext.getCurrentWorkingDirectory(), string));
                boolean bl = this.ftp.retrieveFile(string2, (OutputStream)fileOutputStream);
                ((OutputStream)fileOutputStream).close();
                if (!bl) {
                    return this.returnErrorFalse("Cannot get file: " + this.ftp.getReplyString());
                }
            }
            catch (IOException iOException) {
                this.lastError = "Error geting file: " + this.eol + iOException.toString() + this.eol;
            }
        } else {
            return this.returnErrorFalse("Not connected");
        }
        return true;
    }

    public boolean sendTextFile(String string) throws JSException {
        return this.sendFile(0, string, string);
    }

    public boolean sendTextFile(String string, String string2) throws JSException {
        return this.sendFile(0, string, string2);
    }

    public boolean sendBinaryFile(String string) throws JSException {
        return this.sendFile(2, string, string);
    }

    public boolean sendBinaryFile(String string, String string2) throws JSException {
        return this.sendFile(2, string, string2);
    }

    protected boolean sendFile(int n, String string, String string2) throws JSException {
        this.lastError = null;
        this.lastReply = null;
        if (this.isConnected()) {
            if (!this.checkMode(n)) {
                return this.returnErrorFalse();
            }
            try {
                File file = new File(this.localContext.getCurrentWorkingDirectory(), string);
                if (!file.exists()) {
                    return this.returnErrorFalse("Local file '" + string + "' does not exist");
                }
                if (!file.isFile()) {
                    return this.returnErrorFalse("Local file " + string + " is not a data file");
                }
                if (!file.canRead()) {
                    return this.returnErrorFalse("Local file '" + string + "' cannot be read");
                }
                FileInputStream fileInputStream = new FileInputStream(file);
                boolean bl = this.ftp.storeFile(string2, (InputStream)fileInputStream);
                ((InputStream)fileInputStream).close();
                if (!bl) {
                    return this.returnErrorFalse("Cannot get file: " + this.ftp.getReplyString());
                }
            }
            catch (IOException iOException) {
                this.lastError = "Error storing file: " + this.eol + iOException.toString() + this.eol;
            }
        } else {
            this.returnErrorFalse("Not connected");
        }
        return true;
    }

    protected void checkExceptionMode() throws JSException {
        if (this.exceptionMode) {
            throw new JSException(this.lastError);
        }
    }

    protected boolean returnErrorFalse() throws JSException {
        this.checkExceptionMode();
        return false;
    }

    protected boolean returnErrorFalse(String string) throws JSException {
        this.lastError = string;
        this.checkExceptionMode();
        return false;
    }

    protected String returnErrorNull(String string) throws JSException {
        this.lastError = string;
        this.checkExceptionMode();
        return null;
    }

    protected boolean returnErrorFalse(Exception exception) throws JSException {
        this.lastError = exception.toString();
        this.checkExceptionMode();
        return false;
    }

    private boolean checkMode(int n) {
        if (this.currentMode != n) {
            try {
                boolean bl = this.ftp.setFileType(n);
                if (!bl) {
                    return false;
                }
                this.currentMode = n;
            }
            catch (IOException iOException) {
                this.lastError = "Cannot change mode, error: " + this.eol + iOException + this.eol;
                return false;
            }
        }
        return true;
    }
}

