//----------------------------------------------------------------------------
//
// Module:      MessageDialog.java      
//
// Description: Message box dialog for FesiFTP
//
// FESI Copyright (c) Jean-Marc Lugrin, 2000
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------------------------

import java.awt.*;
import java.awt.event.*;

class MessageDialog extends Dialog {
           

    /**
     * Create a message dialog box, asking user to acknowledge it
     *
     * @param   parent  The parent frame
     * @param   center  Where to put the window
     * @param   title  The title of the window
     * @param   message  The message text
     */
    MessageDialog (Frame parent, Point center, String title, String message) {
        super(parent, title, true);

        // Specify a LayoutManager for it
        this.setLayout(new GridLayout(1, 2));
        Label l = new Label(message, Label.CENTER);
        this.add(l);

        Button bOk = new Button("OK");
        bOk.addActionListener( new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                MessageDialog.this.dispose();
            }
        });
        this.add(bOk);
        
        this.pack();
        setLocation (center.x - (getSize ().width / 2), center.y - (getSize ().height / 2));
    }

}