//----------------------------------------------------------------------------
//
// Module:      JMenuBarDocumentHandler.java      
//
// Description: Handles JMenuBar elements
//
// FESI Copyright (c) Jean-Marc Lugrin, 2000
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------------------------

package FesiForm;

import org.xml.sax.*;
import FESI.jslib.*;

import javax.swing.*;
import java.awt.*;
import java.util.Vector;


public class JMenuBarDocumentHandler extends DefaultDocumentHandler 
                                    implements DocumentHandler {

    DocumentHandler previousDocumentHandler;
    String containerName;
    String script = null;
    Container container = null;
    JMenuBar menuBar = null; // for inside components as menu items
    
    public JMenuBarDocumentHandler(String cn,
                                    DocumentHandler pdh,
                                    Container ct, 
                                    GuiContext gc, 
                                    boolean trace) {
        super(gc, trace);
        this.previousDocumentHandler = pdh;
        this.container = ct;
        this.containerName = cn;
        // Validate assumption
        if (!cn.equals("JMenuBar")) throw new IllegalArgumentException("** Unexpected container name for JFrame: " + cn);
    }
  
      
    // Receive notification of the beginning of an element.
    public void startElement(String name, AttributeList atts) throws SAXException {
        if (trace) System.out.println("MENUBAR START_ELEMENT: <" + name + ">, " + 
                                         atts.getLength() + " attribute(s)");                                        
        if (name.equals("JMenuBar")) {
             menuBar = (JMenuBar) createComponent(JMenuBar.class, atts);
             processOptionalId(menuBar, atts);
             processComponentAttributes(menuBar, atts);
             String script = saveScript(menuBar, atts);

        } else if (name.equals("JMenu")) {
                DocumentHandler dh = 
                    new JMenuDocumentHandler("JMenu", this, menuBar, guiContext, trace);
                guiContext.parser.setDocumentHandler(dh);
                dh.startElement(name, atts);
            
        } else {
            throw new SAXException("Unexpected ELEMENT in menubar ignored: " + name);
        }
    }

    // Receive notification of the end of an element. 
    public void endElement(String name) throws SAXException {
        if (trace) System.out.println("MENUBAR END_ELEMENT: </" + name + ">");
        if (name.equals("JMenu")) {
            guiContext.parser.setDocumentHandler(this);
        } else if (name.equals("JMenuBar")) {
            if (container instanceof JFrame) {
                JFrame jf = (JFrame) container;
                jf.setJMenuBar(menuBar);
            } else if (container instanceof JDialog) {
                JDialog jd = (JDialog) container;
                jd.setJMenuBar(menuBar);
            } else {
                container.add(menuBar);
            }
            processScript(menuBar, script);
            previousDocumentHandler.endElement(name);
        } else {
            throw new SAXException("Unexpected ELEMENT end in menubar ignored: " + name);
        }
    }
    

 }