//----------------------------------------------------------------------------
//
// Module:      JMenuDocumentHandler.java      
//
// Description: Handles JMenu elements and menu content elements
//
// FESI Copyright (c) Jean-Marc Lugrin, 2000
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------------------------

package FesiForm;

import org.xml.sax.*;
import FESI.jslib.*;

import javax.swing.*;
import java.awt.*;
import java.util.Vector;


public class JMenuDocumentHandler extends DefaultDocumentHandler 
                                    implements DocumentHandler {

    DocumentHandler previousDocumentHandler;
    String script = null;
    Container container = null;
    JMenu menu = null; // for inside components as menu items
    String containerName;
    ButtonGroup buttonGroup = null;

    public JMenuDocumentHandler(String cn,
                                    DocumentHandler pdh,
                                    Container ct, 
                                    GuiContext gc, 
                                    boolean trace) {
        super(gc, trace);
        // System.out.println("=== " + pdh);
        this.previousDocumentHandler = pdh;
        this.container = ct;
        this.containerName = cn;
        // Validate assumption
        if (!cn.equals("JMenu")) System.err.println("** Unexpected container name for JFrame: " + cn);
    }
  
      
    // Receive notification of the beginning of an element.
    public void startElement(String name, AttributeList atts) throws SAXException {
        if (trace) System.out.println("MENU START_ELEMENT: <" + name + ">, " + 
                                         atts.getLength() + " attribute(s)");
                                        
        if (name.equals("JMenu")) {
             menu = (JMenu) createComponent(JMenu.class, atts);
             processOptionalId(menu, atts);
             processComponentAttributes(menu, atts);
             processJComponentAttributes(menu, atts);
             processAbstractButtonAttributes(menu, atts);
             container.add(menu);
             script = saveScript(menu, atts);
            
        } else if (name.equals("JMenuItem")) {
            JMenuItem jb = (JMenuItem) createComponent(JMenuItem.class, atts);
            processOptionalId(jb, atts);
            processComponentAttributes(jb, atts);
            processJComponentAttributes(menu, atts);
            processAbstractButtonAttributes(jb, atts);
            menu.add(jb);
            processScript(jb, saveScript(jb, atts));
            
        } else if (name.equals("JCheckBoxMenuItem")) {
            JCheckBoxMenuItem jb = (JCheckBoxMenuItem) createComponent(JCheckBoxMenuItem.class, atts);
            processOptionalId(jb, atts);
            processComponentAttributes(jb, atts);
            processAbstractButtonAttributes(jb, atts);
            menu.add(jb);
            processScript(jb, saveScript(jb, atts));

        } else if (name.equals("JRadioButtonMenuItem")) {
            JRadioButtonMenuItem jb = (JRadioButtonMenuItem) createComponent(JRadioButtonMenuItem.class, atts);
            processOptionalId(jb, atts);
            processComponentAttributes(jb, atts);
            processJComponentAttributes(menu, atts);
            processAbstractButtonAttributes(jb, atts);
            if (buttonGroup==null) buttonGroup = new ButtonGroup();
            buttonGroup.add(jb);
            menu.add(jb);
            processScript(jb, saveScript(jb, atts));

        } else if (name.equals("JSeparator")) {
            JSeparator component = (JSeparator) createComponent(JSeparator.class, atts);
            processComponentAttributes(component, atts);
            processJComponentAttributes(menu, atts);
            menu.add(component);
            processScript(component, saveScript(component, atts));
            
        } else {
            System.err.println("Unexpected ELEMENT in menu ignored: " + name);
        }
    }

    // Receive notification of the end of an element. 
    public void endElement(String name) throws SAXException {
        if (trace) System.out.println("MENU END_ELEMENT: </" + name + ">");
        if (name.equals("JMenu")) {
            // System.out.println("***" + previousDocumentHandler);
            previousDocumentHandler.endElement(name);
        }
    }
    

 }