//----------------------------------------------------------------------------
//
// Module:      JScrollBarDocumentHandler.java      
//
// Description: Handles JScrollbar elements
//
// FESI Copyright (c) Jean-Marc Lugrin, 2000
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------------------------

package FesiForm;

import org.xml.sax.*;
import FESI.jslib.*;

import javax.swing.*;
import java.awt.*;
import java.util.Vector;


public class JScrollPaneDocumentHandler extends DefaultDocumentHandler 
                                   implements DocumentHandler {

    DocumentHandler previousDocumentHandler;
    String script = null;
    JScrollPane scrollPane = null;
    String containerName;
    Container container;
    String constraint = null;
    
    public JScrollPaneDocumentHandler(String cn,
                                    DocumentHandler pdh, 
                                    Container ct,
                                    GuiContext guiContext, 
                                    boolean trace) {
        super(guiContext, trace);
        this.containerName = cn;
        this.container = ct;
        this.previousDocumentHandler = pdh;
        // Validate assumption
        if (!cn.equals("JScrollPane")) 
                throw new IllegalArgumentException("** Unexpected container name for JScrollPane: " + cn);
    }
  
      
    // Receive notification of the beginning of an element.
    public void startElement(String name, AttributeList atts) throws SAXException {
        if (trace) System.out.println("JScrollPane START_ELEMENT: <" + name + ">, " + 
                                         atts.getLength() + " attribute(s)");
        if (name.equals("JScrollPane")) {
            processOptionalId(scrollPane, atts);
            scrollPane = (JScrollPane) createComponent(JScrollPane.class, atts);
            processComponentAttributes(scrollPane, atts);
            processHORIZONTALSCROLLBARPOLICY(scrollPane, atts);
            processVERTICALSCROLLBARPOLICY(scrollPane, atts);
            constraint = getAttribute("constraint", atts);
            script = saveScript(scrollPane, atts);
            DocumentHandler dh = 
                new ContentDocumentHandler("JScrollPane", this, null, scrollPane.getViewport(), guiContext, trace, 1);
            guiContext.parser.setDocumentHandler(dh);
            dh.startElement(name, atts);
        } else {
            throw new SAXException("Unexpected ELEMENT in scrollPane ignored: " + name);
        }
    }

    // Receive notification of the end of an element. 
    public void endElement(String name) throws SAXException {
        if (trace) System.out.println("JScrollPane END_ELEMENT: </" + name + ">");
        if (name.equals("JScrollPane")) {  
            addConstrained(container, scrollPane, constraint);
            processScript(scrollPane, script);
            previousDocumentHandler.endElement(name);
        } else {
            throw new SAXException("Unexpected ELEMENT end in scrollPane ignored: " + name);
        }
    }
    
     protected int processHORIZONTALSCROLLBARPOLICY(JScrollPane jsp, AttributeList atts) throws SAXException {
         int policy = ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER;
         String p = getAttribute("horizontalScrollBarPolicy", atts);
         if (p != null) {
             p = p.toLowerCase();
             if (trace) System.out.println("  HORIZONTALSCROLLBARPOLICY: " + p);
             if (p.equals("always")) {
                 policy = ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS;
             } else if (p.equals("asneeded")||p.equals("a_needed")) {
                 policy = ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED;
             } else if (!p.equals("never")) {
                 throw new SAXException("Bad horizontal policy name value for scroll bar policy: " + p);
             }
             jsp.setHorizontalScrollBarPolicy(policy);
         }
         return policy;
     }
    
     protected int processVERTICALSCROLLBARPOLICY(JScrollPane jsp, AttributeList atts) throws SAXException {
         int policy = ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER;
         String p = getAttribute("horizontalScrollBarPolicy", atts);
         if (p != null) {
             p = p.toLowerCase();
             if (trace) System.out.println("  VERTICALSCROLLBARPOLICY: " + p);
             if (p.equals("always")) {
                 policy = ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS;
             } else if (p.equals("asneeded")||p.equals("a_needed")) {
                 policy = ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED;
             } else if (!p.equals("never")) {
                 throw new SAXException("Bad vertical policy name value for scroll bar policy: " + p);
             }
             jsp.setVerticalScrollBarPolicy(policy);
         }
         return policy;
     }
 }