//----------------------------------------------------------------------------
//
// Module:      JToolBarDocumentHandler.java      
//
// Description: Handles JToolBar elements
//
// FESI Copyright (c) Jean-Marc Lugrin, 2000
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------------------------
package FesiForm;

import org.xml.sax.*;
import FESI.jslib.*;

import javax.swing.*;
import java.awt.*;
import java.util.Vector;


public class JToolBarDocumentHandler extends DefaultDocumentHandler 
                                   implements DocumentHandler {

    DocumentHandler previousDocumentHandler;
    String script = null;
    JToolBar toolBar = null;
    String containerName;
    Container container;
    String constraint = null;
    
    public JToolBarDocumentHandler(String cn,
                                    DocumentHandler pdh, 
                                    Container ct,
                                    GuiContext guiContext, 
                                    boolean trace) {
        super(guiContext, trace);
        this.containerName = cn;
        this.container = ct;
        this.previousDocumentHandler = pdh;
        // Validate assumption
        if (!cn.equals("JToolBar")) throw new IllegalArgumentException("** Unexpected container name for JToolBar: " + cn);
    }
  
      
    // Receive notification of the beginning of an element.
    public void startElement(String name, AttributeList atts) throws SAXException {
        if (trace) System.out.println("JToolBar START_ELEMENT: <" + name + ">, " + 
                                         atts.getLength() + " attribute(s)");
        if (name.equals("JToolBar")) {
            processOptionalId(toolBar, atts);
            toolBar = (JToolBar) createComponent(JToolBar.class, atts);
            processComponentAttributes(toolBar, atts);
            processBORDERPAINTED(toolBar, atts);
            processFLOATABLE(toolBar, atts);
            constraint = getAttribute("constraint", atts);
            script = saveScript(toolBar, atts);
            DocumentHandler dh = 
                new ContentDocumentHandler("JToolBar", this, null, toolBar, guiContext, trace, -1);
            guiContext.parser.setDocumentHandler(dh);
            dh.startElement(name, atts);
        } else {
            throw new SAXException("Unexpected ELEMENT in toolBar ignored: " + name);
        }
    }

    // Receive notification of the end of an element. 
    public void endElement(String name) throws SAXException {
        if (trace) System.out.println("JToolBar END_ELEMENT: </" + name + ">");
        if (name.equals("JToolBar")) {  
            addConstrained(container, toolBar, constraint);
            processScript(toolBar, script);
            previousDocumentHandler.endElement(name);
        } else {
            throw new SAXException("Unexpected ELEMENT end in toolBar ignored: " + name);
        }
    }


     protected boolean processBORDERPAINTED(JToolBar jb, AttributeList atts) throws SAXException {
         boolean tf = false;
         String tfString = getAttribute("selected", atts);
         if (tfString != null) {
             tfString = tfString.toLowerCase();
             if (trace) System.out.println("  BORDERPAINTED: " + tfString);
             if (tfString.equals("true")) {
                 tf = true;
             } else if (!tfString.equals("false")) {
                 throw new SAXException("Bad true/false value for borderPainted: " + tf);
             }
             jb.setBorderPainted(tf);
         }
         return tf;
     }

     protected boolean processFLOATABLE(JToolBar jb, AttributeList atts) throws SAXException {
         boolean tf = false;
         String tfString = getAttribute("floatable", atts);
         if (tfString != null) {
             tfString = tfString.toLowerCase();
             if (trace) System.out.println("  FLOATABLE: " + tfString);
             if (tfString.equals("true")) {
                 tf = true;
             } else if (!tfString.equals("false")) {
                 throw new SAXException("Bad true/false value for floatable: " + tf);
             }
             jb.setFloatable(tf);
         }
         return tf;
     }
 }