/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class InputHandler {
    protected static XMLReader createParser() throws FOPException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            MessageHandler.logln("Using " + xMLReader.getClass().getName() + " as SAX2 Parser");
            return xMLReader;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new FOPException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new FOPException(sAXException);
        }
    }

    public static InputSource fileInputSource(File file) {
        String string = file.getAbsolutePath();
        String string2 = System.getProperty("file.separator");
        if (string2 != null && string2.length() == 1) {
            string = string.replace(string2.charAt(0), '/');
        }
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = String.valueOf('/') + string;
        }
        try {
            return new InputSource(new URL("file", null, string).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public abstract InputSource getInputSource();

    public abstract XMLReader getParser() throws FOPException;

    public static InputSource urlInputSource(URL uRL) {
        return new InputSource(uRL.toString());
    }
}

