/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.extensions;

import java.util.Vector;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.extensions.Label;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;

public class Outline
extends ExtensionObj {
    private Label _label;
    private Vector _outlines = new Vector();
    private String _internalDestination = this.properties.get("internal-destination").getString();
    private String _externalDestination = this.properties.get("external-destination").getString();
    private Outline _parentOutline;
    private Object _rendererObject;

    public Outline(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        if (this._externalDestination != null && !this._externalDestination.equals("")) {
            this.log.warn("fox:outline external-destination not supported currently.");
        }
        if (this._internalDestination == null || this._internalDestination.equals("")) {
            this.log.warn("fox:outline requires an internal-destination.");
        }
        FObj fObj2 = this.getParent();
        while (fObj2 != null) {
            if (fObj2 instanceof Outline) {
                this._parentOutline = (Outline)fObj2;
                break;
            }
            fObj2 = fObj2.getParent();
        }
    }

    protected void addChild(FONode fONode) {
        if (fONode instanceof Label) {
            this._label = (Label)fONode;
        } else if (fONode instanceof Outline) {
            this._outlines.addElement(fONode);
        }
        super.addChild(fONode);
    }

    public String getInternalDestination() {
        return this._internalDestination;
    }

    public Label getLabel() {
        return this._label == null ? new Label(this, this.properties) : this._label;
    }

    public Vector getOutlines() {
        return this._outlines;
    }

    public Outline getParentOutline() {
        return this._parentOutline;
    }

    public Object getRendererObject() {
        return this._rendererObject;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setRendererObject(Object object) {
        this._rendererObject = object;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) {
            return new Outline(fObj, propertyList);
        }
    }
}

