/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.TextState;

public class FOText
extends FONode {
    protected char[] ca;
    protected int start = 0;
    protected int length;
    FontState fs;
    float red;
    float green;
    float blue;
    int wrapOption;
    int whiteSpaceCollapse;
    int verticalAlign;
    protected boolean underlined = false;
    protected boolean overlined = false;
    protected boolean lineThrough = false;
    TextState ts;

    public FOText(char[] cArray, int n, int n2, FObj fObj) {
        super(fObj);
        this.ca = new char[n2 - n];
        int n3 = n;
        while (n3 < n2) {
            this.ca[n3 - n] = cArray[n3];
            ++n3;
        }
        this.length = n2 - n;
    }

    protected static int addRealText(BlockArea blockArea, FontState fontState, float f, float f2, float f3, int n, LinkSet linkSet, int n2, char[] cArray, int n3, int n4, TextState textState, int n5) {
        int n6 = n3;
        int n7 = n4;
        char[] cArray2 = cArray;
        LineArea lineArea = blockArea.getCurrentLineArea();
        if (lineArea == null) {
            return n3;
        }
        lineArea.changeFont(fontState);
        lineArea.changeColor(f, f2, f3);
        lineArea.changeWrapOption(n);
        lineArea.changeWhiteSpaceCollapse(n2);
        lineArea.changeVerticalAlign(n5);
        blockArea.setupLinkSet(linkSet);
        n6 = lineArea.addText(cArray2, n6, n7, linkSet, textState);
        while (n6 != -1) {
            lineArea = blockArea.createNextLineArea();
            if (lineArea == null) {
                return n6;
            }
            lineArea.changeFont(fontState);
            lineArea.changeColor(f, f2, f3);
            lineArea.changeWrapOption(n);
            lineArea.changeWhiteSpaceCollapse(n2);
            blockArea.setupLinkSet(linkSet);
            n6 = lineArea.addText(cArray2, n6, n7, linkSet, textState);
        }
        return -1;
    }

    public static int addText(BlockArea blockArea, FontState fontState, float f, float f2, float f3, int n, LinkSet linkSet, int n2, char[] cArray, int n3, int n4, TextState textState, int n5) {
        if (fontState.getFontVariant() == 73) {
            FontState fontState2;
            try {
                int c = (int)((double)fontState.getFontSize() * 0.8);
                fontState2 = new FontState(fontState.getFontInfo(), fontState.getFontFamily(), fontState.getFontStyle(), fontState.getFontWeight(), c, 53);
            }
            catch (FOPException fOPException) {
                fontState2 = fontState;
            }
            int n6 = n3;
            while (n6 < n4) {
                FontState fontState3;
                int n7;
                int n8 = n6;
                char c = cArray[n6];
                boolean bl = Character.isLetter(c) && Character.isLowerCase(c);
                while (bl == (Character.isLetter(c) && Character.isLowerCase(c))) {
                    if (bl) {
                        cArray[n6] = Character.toUpperCase(c);
                    }
                    if (++n6 == n4) break;
                    c = cArray[n6];
                }
                if ((n7 = FOText.addRealText(blockArea, fontState3 = bl ? fontState2 : fontState, f, f2, f3, n, linkSet, n2, cArray, n8, n6, textState, n5)) == -1) continue;
                return n7;
            }
            return -1;
        }
        return FOText.addRealText(blockArea, fontState, f, f2, f3, n, linkSet, n2, cArray, n3, n4, textState, n5);
    }

    public Status layout(Area area) throws FOPException {
        if (!(area instanceof BlockArea)) {
            this.log.error("text outside block area" + new String(this.ca, this.start, this.length));
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.parent.properties.get("font-family").getString();
            String string2 = this.parent.properties.get("font-style").getString();
            String string3 = this.parent.properties.get("font-weight").getString();
            int n = this.parent.properties.get("font-size").getLength().mvalue();
            int n2 = this.parent.properties.get("font-variant").getEnum();
            int n3 = this.parent.properties.get("letter-spacing").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, string3, n, n2, n3);
            ColorType colorType = this.parent.properties.get("color").getColorType();
            this.red = colorType.red();
            this.green = colorType.green();
            this.blue = colorType.blue();
            this.verticalAlign = this.parent.properties.get("vertical-align").getEnum();
            this.wrapOption = this.parent.properties.get("wrap-option").getEnum();
            this.whiteSpaceCollapse = this.parent.properties.get("white-space-collapse").getEnum();
            this.ts = new TextState();
            this.ts.setUnderlined(this.underlined);
            this.ts.setOverlined(this.overlined);
            this.ts.setLineThrough(this.lineThrough);
            this.marker = this.start;
        }
        int n = this.marker;
        this.marker = FOText.addText((BlockArea)area, this.fs, this.red, this.green, this.blue, this.wrapOption, this.getLinkSet(), this.whiteSpaceCollapse, this.ca, this.marker, this.length, this.ts, this.verticalAlign);
        if (this.marker == -1) {
            return new Status(1);
        }
        if (this.marker != n) {
            return new Status(3);
        }
        return new Status(2);
    }

    public void setLineThrough(boolean bl) {
        this.lineThrough = bl;
    }

    public void setOverlined(boolean bl) {
        this.overlined = bl;
    }

    public void setUnderlined(boolean bl) {
        this.underlined = bl;
    }

    public boolean willCreateArea() {
        this.whiteSpaceCollapse = this.parent.properties.get("white-space-collapse").getEnum();
        if (this.whiteSpaceCollapse == 27 && this.length > 0) {
            return true;
        }
        int n = this.start;
        while (n < this.start + this.length) {
            char c = this.ca[n];
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                return true;
            }
            ++n;
        }
        return false;
    }
}

