/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.Vector;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPathPaint;

public class PDFColor
extends PDFPathPaint {
    protected static double blackFactor = 2.0;
    protected double red = -1.0;
    protected double green = -1.0;
    protected double blue = -1.0;
    protected double cyan = -1.0;
    protected double magenta = -1.0;
    protected double yellow = -1.0;
    protected double black = -1.0;

    public PDFColor(double d, double d2, double d3) {
        this.colorSpace = new ColorSpace(ColorSpace.DEVICE_RGB);
        this.red = d;
        this.green = d2;
        this.blue = d3;
    }

    public PDFColor(double d, double d2, double d3, double d4) {
        this.colorSpace = new ColorSpace(ColorSpace.DEVICE_CMYK);
        this.cyan = d;
        this.magenta = d2;
        this.yellow = d3;
        this.black = d4;
    }

    public PDFColor(int n, int n2, int n3) {
        this((double)n / 255.0, (double)n2 / 255.0, (double)n3 / 255.0);
    }

    public PDFColor(ColorType colorType) {
        this.colorSpace = new ColorSpace(ColorSpace.DEVICE_RGB);
        this.red = colorType.red();
        this.green = colorType.green();
        this.blue = colorType.blue();
    }

    public double black() {
        return this.black;
    }

    public double blue() {
        return this.blue;
    }

    public int blue255() {
        return (int)(this.blue * 255.0);
    }

    protected void convertCMYKtoGRAY() {
        double d = 0.0;
        d = this.cyan;
        if (this.magenta < d) {
            d = this.magenta;
        }
        if (this.yellow < d) {
            d = this.yellow;
        }
        this.black = d / blackFactor;
    }

    protected void convertCMYKtoRGB() {
        this.red = 1.0 - this.cyan;
        this.green = 1.0 - this.green;
        this.blue = 1.0 - this.yellow;
        this.red = this.black / blackFactor + this.red;
        this.green = this.black / blackFactor + this.green;
        this.blue = this.black / blackFactor + this.blue;
    }

    protected void convertGRAYtoCMYK() {
        this.cyan = this.black;
        this.magenta = this.black;
        this.yellow = this.black;
    }

    protected void convertGRAYtoRGB() {
        this.red = 1.0 - this.black;
        this.green = 1.0 - this.black;
        this.blue = 1.0 - this.black;
    }

    protected void convertRGBtoCMYK() {
        this.cyan = 1.0 - this.red;
        this.magenta = 1.0 - this.green;
        this.yellow = 1.0 - this.blue;
        this.black = 0.0;
    }

    protected void convertRGBtoGRAY() {
        double d = 0.0;
        d = this.red;
        if (this.green < d) {
            d = this.green;
        }
        if (this.blue < d) {
            d = this.blue;
        }
        this.black = 1.0 - d / blackFactor;
    }

    public double cyan() {
        return this.cyan;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PDFColor)) {
            return false;
        }
        PDFColor pDFColor = (PDFColor)object;
        return pDFColor.red == this.red && pDFColor.green == this.green && pDFColor.blue == this.blue;
    }

    public String getColorSpaceOut(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.colorSpace.getColorSpace() == ColorSpace.DEVICE_RGB) {
            boolean bl2 = false;
            if (this.red == this.green && this.red == this.blue) {
                bl2 = true;
            }
            if (bl) {
                if (bl2) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut(this.red)) + " g\n");
                } else {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut(this.red)) + " " + PDFNumber.doubleOut(this.green) + " " + PDFNumber.doubleOut(this.blue) + " " + " rg \n");
                }
            } else if (bl2) {
                stringBuffer.append(String.valueOf(PDFNumber.doubleOut(this.red)) + " G\n");
            } else {
                stringBuffer.append(String.valueOf(PDFNumber.doubleOut(this.red)) + " " + PDFNumber.doubleOut(this.green) + " " + PDFNumber.doubleOut(this.blue) + " " + " RG \n");
            }
        } else if (this.colorSpace.getColorSpace() == ColorSpace.DEVICE_CMYK) {
            if (bl) {
                stringBuffer.append(String.valueOf(PDFNumber.doubleOut(this.cyan)) + " " + PDFNumber.doubleOut(this.magenta) + " " + PDFNumber.doubleOut(this.yellow) + " " + PDFNumber.doubleOut(this.black) + " k \n");
            } else {
                stringBuffer.append(String.valueOf(PDFNumber.doubleOut(this.cyan)) + " " + PDFNumber.doubleOut(this.magenta) + " " + PDFNumber.doubleOut(this.yellow) + " " + PDFNumber.doubleOut(this.black) + " K \n");
            }
        } else if (bl) {
            stringBuffer.append(String.valueOf(PDFNumber.doubleOut(this.black)) + " g \n");
        } else {
            stringBuffer.append(String.valueOf(PDFNumber.doubleOut(this.black)) + " G \n");
        }
        return stringBuffer.toString();
    }

    public Vector getVector() {
        Vector<Double> vector = new Vector<Double>();
        if (this.colorSpace.getColorSpace() == ColorSpace.DEVICE_RGB) {
            vector.addElement(new Double(this.red));
            vector.addElement(new Double(this.green));
            vector.addElement(new Double(this.blue));
        } else if (this.colorSpace.getColorSpace() == ColorSpace.DEVICE_CMYK) {
            vector.addElement(new Double(this.cyan));
            vector.addElement(new Double(this.magenta));
            vector.addElement(new Double(this.yellow));
            vector.addElement(new Double(this.black));
        } else {
            vector.addElement(new Double(this.black));
        }
        return vector;
    }

    public double green() {
        return this.green;
    }

    public int green255() {
        return (int)(this.green * 255.0);
    }

    public double magenta() {
        return this.magenta;
    }

    public double red() {
        return this.red;
    }

    public int red255() {
        return (int)(this.red * 255.0);
    }

    public void setColorSpace(int n) {
        int n2 = this.colorSpace.getColorSpace();
        if (n2 != n) {
            if (n2 == ColorSpace.DEVICE_RGB) {
                if (n == ColorSpace.DEVICE_CMYK) {
                    this.convertRGBtoCMYK();
                } else {
                    this.convertRGBtoGRAY();
                }
            } else if (n2 == ColorSpace.DEVICE_CMYK) {
                if (n == ColorSpace.DEVICE_RGB) {
                    this.convertCMYKtoRGB();
                } else {
                    this.convertCMYKtoGRAY();
                }
            } else if (n == ColorSpace.DEVICE_RGB) {
                this.convertGRAYtoRGB();
            } else {
                this.convertGRAYtoCMYK();
            }
            this.colorSpace.setColorSpace(n);
        }
    }

    byte[] toPDF() {
        return new byte[0];
    }

    public double yellow() {
        return this.yellow;
    }
}

