/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.configuration;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.ConfigurationParser;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ConfigurationReader {
    private static boolean errorDump = false;
    private InputSource filename;

    public ConfigurationReader(InputSource inputSource) {
        this.filename = inputSource;
    }

    public static XMLReader createParser() throws FOPException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            MessageHandler.logln("Using " + xMLReader.getClass().getName() + " as SAX2 Parser");
            return xMLReader;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new FOPException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new FOPException(sAXException);
        }
    }

    public void dumpError(Exception exception) {
        if (errorDump) {
            if (exception instanceof SAXException) {
                exception.printStackTrace();
                if (((SAXException)exception).getException() != null) {
                    ((SAXException)exception).getException().printStackTrace();
                }
            } else {
                exception.printStackTrace();
            }
        }
    }

    public void setDumpError(boolean bl) {
        errorDump = bl;
    }

    public void start() throws FOPException {
        XMLReader xMLReader = ConfigurationReader.createParser();
        ConfigurationParser configurationParser = new ConfigurationParser();
        xMLReader.setContentHandler(configurationParser);
        try {
            xMLReader.parse(this.filename);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof FOPException) {
                throw (FOPException)sAXException.getException();
            }
            throw new FOPException(sAXException);
        }
        catch (IOException iOException) {
            throw new FOPException(iOException);
        }
    }
}

