/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layout.TextState;

public class PageNumber
extends FObj {
    float red;
    float green;
    float blue;
    int wrapOption;
    int whiteSpaceCollapse;
    TextState ts;

    public PageNumber(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:page-number";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        if (!(area instanceof BlockArea)) {
            this.log.warn("page-number outside block area");
            return new Status(1);
        }
        if (this.marker == -1000) {
            object = this.propMgr.getAccessibilityProps();
            AuralProps auralProps = this.propMgr.getAuralProps();
            BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
            BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
            MarginInlineProps marginInlineProps = this.propMgr.getMarginInlineProps();
            RelativePositionProps relativePositionProps = this.propMgr.getRelativePositionProps();
            ColorType colorType = this.properties.get("color").getColorType();
            this.red = colorType.red();
            this.green = colorType.green();
            this.blue = colorType.blue();
            this.wrapOption = this.properties.get("wrap-option").getEnum();
            this.whiteSpaceCollapse = this.properties.get("white-space-collapse").getEnum();
            this.ts = new TextState();
            this.marker = 0;
            String string = this.properties.get("id").getString();
            area.getIDReferences().initializeID(string, area);
        }
        object = area.getPage().getFormattedNumber();
        this.marker = FOText.addText((BlockArea)area, this.propMgr.getFontState(area.getFontInfo()), this.red, this.green, this.blue, this.wrapOption, null, this.whiteSpaceCollapse, ((String)object).toCharArray(), 0, ((String)object).length(), this.ts, 8);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new PageNumber(fObj, propertyList);
        }
    }
}

