/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.fonts.FontFileReader;
import org.apache.fop.fonts.TTFDirTabEntry;
import org.apache.fop.fonts.TTFFile;
import org.apache.fop.messaging.MessageHandler;

public class TTFSubSetFile
extends TTFFile {
    byte[] output = null;
    int realSize = 0;
    int currentPos = 0;
    int cvtDirOffset = 0;
    int fpgmDirOffset = 0;
    int glyfDirOffset = 0;
    int headDirOffset = 0;
    int hheaDirOffset = 0;
    int hmtxDirOffset = 0;
    int locaDirOffset = 0;
    int maxpDirOffset = 0;
    int prepDirOffset = 0;
    int checkSumAdjustmentOffset = 0;
    int locaOffset = 0;

    private void createCheckSumAdjustment() {
        long l = this.getLongCheckSum(0, this.realSize);
        int n = (int)(-1313820742L - l);
        this.writeULong(this.checkSumAdjustmentOffset, n);
    }

    private void createCvt(FontFileReader fontFileReader) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("cvt ");
        if (tTFDirTabEntry != null) {
            this.pad4();
            this.seek_tab(fontFileReader, "cvt ", 0L);
            System.arraycopy(fontFileReader.getBytes((int)tTFDirTabEntry.offset, (int)tTFDirTabEntry.length), 0, this.output, this.currentPos, (int)tTFDirTabEntry.length);
            int n = this.getCheckSum(this.currentPos, (int)tTFDirTabEntry.length);
            this.writeULong(this.cvtDirOffset, n);
            this.writeULong(this.cvtDirOffset + 4, this.currentPos);
            this.writeULong(this.cvtDirOffset + 8, (int)tTFDirTabEntry.length);
            this.currentPos += (int)tTFDirTabEntry.length;
            this.realSize += (int)tTFDirTabEntry.length;
        } else {
            throw new IOException("Can't find cvt table");
        }
    }

    private void createDirectory() {
        int n = 9;
        this.writeByte((byte)0);
        this.writeByte((byte)1);
        this.writeByte((byte)0);
        this.writeByte((byte)0);
        this.realSize += 4;
        this.writeUShort(n);
        this.realSize += 2;
        int n2 = this.maxPow2(n);
        int n3 = n2 * 16;
        this.writeUShort(n3);
        this.realSize += 2;
        this.writeUShort(n2);
        this.realSize += 2;
        this.writeUShort(n * 16 - n3);
        this.realSize += 2;
        this.writeString("cvt ");
        this.cvtDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("fpgm");
        this.fpgmDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("glyf");
        this.glyfDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("head");
        this.headDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("hhea");
        this.hheaDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("hmtx");
        this.hmtxDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("loca");
        this.locaDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("maxp");
        this.maxpDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("prep");
        this.prepDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
    }

    private void createFpgm(FontFileReader fontFileReader) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("fpgm");
        if (tTFDirTabEntry != null) {
            this.pad4();
            this.seek_tab(fontFileReader, "fpgm", 0L);
            System.arraycopy(fontFileReader.getBytes((int)tTFDirTabEntry.offset, (int)tTFDirTabEntry.length), 0, this.output, this.currentPos, (int)tTFDirTabEntry.length);
            int n = this.getCheckSum(this.currentPos, (int)tTFDirTabEntry.length);
            this.writeULong(this.fpgmDirOffset, n);
            this.writeULong(this.fpgmDirOffset + 4, this.currentPos);
            this.writeULong(this.fpgmDirOffset + 8, (int)tTFDirTabEntry.length);
            this.currentPos += (int)tTFDirTabEntry.length;
            this.realSize += (int)tTFDirTabEntry.length;
        } else {
            throw new IOException("Can't find fpgm table");
        }
    }

    private void createGlyf(FontFileReader fontFileReader, Hashtable hashtable) throws IOException {
        int n;
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("glyf");
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (tTFDirTabEntry != null) {
            this.pad4();
            n3 = this.currentPos;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                n = 0;
                Integer n5 = (Integer)enumeration.nextElement();
                Integer n6 = (Integer)hashtable.get(n5);
                int n7 = 0;
                n7 = n5 >= this.mtx_tab.length - 1 ? (int)this.lastLoca : (int)this.mtx_tab[n5.intValue() + 1].offset;
                n = n7 - (int)this.mtx_tab[n5.intValue()].offset;
                System.arraycopy(fontFileReader.getBytes((int)tTFDirTabEntry.offset + (int)this.mtx_tab[n5.intValue()].offset, n), 0, this.output, this.currentPos, n);
                this.writeULong(this.locaOffset + n6 * 4, this.currentPos - n3);
                if (this.currentPos - n3 + n > n4) {
                    n4 = this.currentPos - n3 + n;
                }
                this.currentPos += n;
                this.realSize += n;
            }
            n2 = this.currentPos - n3;
            n = this.getCheckSum(n3, n2);
            this.writeULong(this.glyfDirOffset, n);
            this.writeULong(this.glyfDirOffset + 4, n3);
            this.writeULong(this.glyfDirOffset + 8, n2);
            this.currentPos += 12;
            this.realSize += 12;
        } else {
            throw new IOException("Can't find glyf table");
        }
        this.writeULong(this.locaOffset + hashtable.size() * 4, n4);
        n = this.getCheckSum(this.locaOffset, hashtable.size() * 4 + 4);
        this.writeULong(this.locaDirOffset, n);
    }

    private void createHead(FontFileReader fontFileReader) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("head");
        if (tTFDirTabEntry != null) {
            this.pad4();
            this.seek_tab(fontFileReader, "head", 0L);
            System.arraycopy(fontFileReader.getBytes((int)tTFDirTabEntry.offset, (int)tTFDirTabEntry.length), 0, this.output, this.currentPos, (int)tTFDirTabEntry.length);
            this.checkSumAdjustmentOffset = this.currentPos + 8;
            this.output[this.currentPos + 8] = 0;
            this.output[this.currentPos + 9] = 0;
            this.output[this.currentPos + 10] = 0;
            this.output[this.currentPos + 11] = 0;
            this.output[this.currentPos + 50] = 0;
            this.output[this.currentPos + 51] = 1;
            int n = this.getCheckSum(this.currentPos, (int)tTFDirTabEntry.length);
            this.writeULong(this.headDirOffset, n);
            this.writeULong(this.headDirOffset + 4, this.currentPos);
            this.writeULong(this.headDirOffset + 8, (int)tTFDirTabEntry.length);
            this.currentPos += (int)tTFDirTabEntry.length;
            this.realSize += (int)tTFDirTabEntry.length;
        } else {
            throw new IOException("Can't find head table");
        }
    }

    private void createHhea(FontFileReader fontFileReader, int n) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("hhea");
        if (tTFDirTabEntry != null) {
            this.pad4();
            this.seek_tab(fontFileReader, "hhea", 0L);
            System.arraycopy(fontFileReader.getBytes((int)tTFDirTabEntry.offset, (int)tTFDirTabEntry.length), 0, this.output, this.currentPos, (int)tTFDirTabEntry.length);
            this.writeUShort((int)tTFDirTabEntry.length + this.currentPos - 2, n);
            int n2 = this.getCheckSum(this.currentPos, (int)tTFDirTabEntry.length);
            this.writeULong(this.hheaDirOffset, n2);
            this.writeULong(this.hheaDirOffset + 4, this.currentPos);
            this.writeULong(this.hheaDirOffset + 8, (int)tTFDirTabEntry.length);
            this.currentPos += (int)tTFDirTabEntry.length;
            this.realSize += (int)tTFDirTabEntry.length;
        } else {
            throw new IOException("Can't find hhea table");
        }
    }

    private void createHmtx(FontFileReader fontFileReader, Hashtable hashtable) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("hmtx");
        int n = hashtable.size() * 2;
        int n2 = hashtable.size() * 2;
        int n3 = n + n2;
        if (tTFDirTabEntry != null) {
            this.pad4();
            int n4 = (int)tTFDirTabEntry.offset;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n5 = (Integer)enumeration.nextElement();
                Integer n6 = (Integer)hashtable.get(n5);
                this.writeUShort(this.currentPos + n6 * 4, this.mtx_tab[n5.intValue()].wx);
                this.writeUShort(this.currentPos + n6 * 4 + 2, this.mtx_tab[n5.intValue()].lsb);
            }
            int n7 = this.getCheckSum(this.currentPos, n3);
            this.writeULong(this.hmtxDirOffset, n7);
            this.writeULong(this.hmtxDirOffset + 4, this.currentPos);
            this.writeULong(this.hmtxDirOffset + 8, n3);
            this.currentPos += n3;
            this.realSize += n3;
        } else {
            throw new IOException("Can't find hmtx table");
        }
    }

    private void createLoca(int n) throws IOException {
        this.pad4();
        this.locaOffset = this.currentPos;
        this.writeULong(this.locaDirOffset + 4, this.currentPos);
        this.writeULong(this.locaDirOffset + 8, n * 4 + 4);
        this.currentPos += n * 4 + 4;
        this.realSize += n * 4 + 4;
    }

    private void createMaxp(FontFileReader fontFileReader, int n) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("maxp");
        if (tTFDirTabEntry != null) {
            this.pad4();
            this.seek_tab(fontFileReader, "maxp", 0L);
            System.arraycopy(fontFileReader.getBytes((int)tTFDirTabEntry.offset, (int)tTFDirTabEntry.length), 0, this.output, this.currentPos, (int)tTFDirTabEntry.length);
            this.writeUShort(this.currentPos + 4, n);
            int n2 = this.getCheckSum(this.currentPos, (int)tTFDirTabEntry.length);
            this.writeULong(this.maxpDirOffset, n2);
            this.writeULong(this.maxpDirOffset + 4, this.currentPos);
            this.writeULong(this.maxpDirOffset + 8, (int)tTFDirTabEntry.length);
            this.currentPos += (int)tTFDirTabEntry.length;
            this.realSize += (int)tTFDirTabEntry.length;
        } else {
            throw new IOException("Can't find maxp table");
        }
    }

    private void createPrep(FontFileReader fontFileReader) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("prep");
        if (tTFDirTabEntry != null) {
            this.pad4();
            this.seek_tab(fontFileReader, "prep", 0L);
            System.arraycopy(fontFileReader.getBytes((int)tTFDirTabEntry.offset, (int)tTFDirTabEntry.length), 0, this.output, this.currentPos, (int)tTFDirTabEntry.length);
            int n = this.getCheckSum(this.currentPos, (int)tTFDirTabEntry.length);
            this.writeULong(this.prepDirOffset, n);
            this.writeULong(this.prepDirOffset + 4, this.currentPos);
            this.writeULong(this.prepDirOffset + 8, (int)tTFDirTabEntry.length);
            this.currentPos += (int)tTFDirTabEntry.length;
            this.realSize += (int)tTFDirTabEntry.length;
        } else {
            throw new IOException("Can't find prep table");
        }
    }

    private int getCheckSum(int n, int n2) {
        return (int)this.getLongCheckSum(n, n2);
    }

    private Vector getIncludedGlyphs(FontFileReader fontFileReader, int n, Integer n2) throws IOException {
        Vector<Integer> vector = new Vector<Integer>();
        vector.addElement(n2);
        int n3 = n + (int)this.mtx_tab[n2.intValue()].offset + 10;
        Integer n4 = null;
        int n5 = 0;
        boolean bl = true;
        while (bl) {
            n5 = fontFileReader.readTTFUShort(n3);
            n4 = new Integer(fontFileReader.readTTFUShort(n3 + 2));
            vector.addElement(n4);
            n3 += 4;
            n3 = (n5 & 1) > 0 ? (n3 += 4) : (n3 += 2);
            if ((n5 & 8) > 0) {
                n3 += 2;
            } else if ((n5 & 0x40) > 0) {
                n3 += 4;
            } else if ((n5 & 0x80) > 0) {
                n3 += 8;
            }
            bl = (n5 & 0x20) > 0;
        }
        return vector;
    }

    private long getLongCheckSum(int n, int n2) {
        int n3 = n2 % 4;
        if (n3 != 0) {
            n2 += n3;
        }
        long l = 0L;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.output[n + n4] << 24;
            n5 += this.output[n + n4 + 1] << 16;
            n5 += this.output[n + n4 + 2] << 16;
            if ((l += (long)(n5 += this.output[n + n4 + 3] << 16)) > -1L) {
                l -= -1L;
            }
            n4 += 4;
        }
        return l;
    }

    private void init(int n) {
        this.output = new byte[n];
        this.realSize = 0;
        this.currentPos = 0;
    }

    private int log2(int n) {
        return (int)(Math.log(n) / Math.log(2.0));
    }

    private int maxPow2(int n) {
        int n2 = 0;
        while (Math.pow(2.0, n2) < (double)n) {
            ++n2;
        }
        return n2 - 1;
    }

    private void pad4() {
        int n = this.currentPos % 4;
        int n2 = 0;
        while (n2 < n) {
            this.output[this.currentPos++] = 0;
            ++this.realSize;
            ++n2;
        }
    }

    public byte[] readFont(FontFileReader fontFileReader, String string, Hashtable hashtable) throws IOException {
        if (!this.checkTTC(fontFileReader, string, false)) {
            throw new IOException("Failed to read font");
        }
        this.output = new byte[fontFileReader.getFileSize()];
        this.readDirTabs(fontFileReader);
        this.readFontHeader(fontFileReader);
        this.getNumGlyphs(fontFileReader);
        this.readHorizontalHeader(fontFileReader);
        this.readHorizontalMetrics(fontFileReader);
        this.readIndexToLocation(fontFileReader);
        this.scanGlyphs(fontFileReader, hashtable);
        this.createDirectory();
        this.createHead(fontFileReader);
        this.createHhea(fontFileReader, hashtable.size());
        this.createHmtx(fontFileReader, hashtable);
        this.createMaxp(fontFileReader, hashtable.size());
        try {
            this.createCvt(fontFileReader);
        }
        catch (IOException iOException) {
            MessageHandler.errorln("TrueType warning: " + iOException.getMessage());
        }
        try {
            this.createFpgm(fontFileReader);
        }
        catch (IOException iOException) {
            MessageHandler.errorln("TrueType warning: " + iOException.getMessage());
        }
        try {
            this.createPrep(fontFileReader);
        }
        catch (IOException iOException) {
            MessageHandler.errorln("TrueType warning: " + iOException.getMessage());
        }
        try {
            this.createLoca(hashtable.size());
        }
        catch (IOException iOException) {
            MessageHandler.errorln("TrueType warning: " + iOException.getMessage());
        }
        try {
            this.createGlyf(fontFileReader, hashtable);
        }
        catch (IOException iOException) {
            MessageHandler.errorln("TrueType warning: " + iOException.getMessage());
        }
        this.pad4();
        this.createCheckSumAdjustment();
        byte[] byArray = new byte[this.realSize];
        System.arraycopy(this.output, 0, byArray, 0, this.realSize);
        return byArray;
    }

    private short readShort(int n) {
        int n2 = this.readUShort(n);
        return (short)n2;
    }

    private int readUShort(int n) {
        int n2 = this.output[n];
        if (n2 < 0) {
            n2 += 256;
        }
        n2 <<= 8;
        n2 = this.output[n + 1] < 0 ? (n2 |= this.output[n + 1] + 256) : (n2 |= this.output[n + 1]);
        return n2;
    }

    private void remapComposite(FontFileReader fontFileReader, Hashtable hashtable, int n, Integer n2) throws IOException {
        int n3 = n + (int)this.mtx_tab[n2.intValue()].offset + 10;
        Integer n4 = null;
        int n5 = 0;
        boolean bl = true;
        while (bl) {
            n5 = fontFileReader.readTTFUShort(n3);
            n4 = new Integer(fontFileReader.readTTFUShort(n3 + 2));
            Integer n6 = (Integer)hashtable.get(n4);
            if (n6 == null) {
                MessageHandler.error("An embedded font contains bad glyph data. Characters might not display correctly.");
                bl = false;
                continue;
            }
            fontFileReader.writeTTFUShort(n3 + 2, n6);
            n3 += 4;
            n3 = (n5 & 1) > 0 ? (n3 += 4) : (n3 += 2);
            if ((n5 & 8) > 0) {
                n3 += 2;
            } else if ((n5 & 0x40) > 0) {
                n3 += 4;
            } else if ((n5 & 0x80) > 0) {
                n3 += 8;
            }
            bl = (n5 & 0x20) > 0;
        }
    }

    private void scanGlyphs(FontFileReader fontFileReader, Hashtable hashtable) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("glyf");
        Hashtable<Integer, Integer> hashtable2 = null;
        Hashtable hashtable3 = new Hashtable();
        int n = hashtable.size();
        if (tTFDirTabEntry != null) {
            Enumeration enumeration;
            while (hashtable2 == null || hashtable2.size() > 0) {
                Serializable serializable;
                Object object;
                hashtable2 = new Hashtable<Integer, Integer>();
                enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    object = (Integer)enumeration.nextElement();
                    if (fontFileReader.readTTFShort(tTFDirTabEntry.offset + this.mtx_tab[((Integer)object).intValue()].offset) >= 0) continue;
                    hashtable3.put(object, hashtable.get(object));
                    serializable = this.getIncludedGlyphs(fontFileReader, (int)tTFDirTabEntry.offset, (Integer)object);
                    Enumeration enumeration2 = ((Vector)serializable).elements();
                    while (enumeration2.hasMoreElements()) {
                        Integer n2 = (Integer)enumeration2.nextElement();
                        if (hashtable.get(n2) != null || hashtable2.get(n2) != null) continue;
                        hashtable2.put(n2, new Integer(n));
                        ++n;
                    }
                }
                object = hashtable2.keys();
                while (object.hasMoreElements()) {
                    serializable = (Integer)object.nextElement();
                    hashtable.put(serializable, hashtable2.get(serializable));
                }
            }
            enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                this.remapComposite(fontFileReader, hashtable, (int)tTFDirTabEntry.offset, (Integer)enumeration.nextElement());
            }
        } else {
            throw new IOException("Can't find glyf table");
        }
    }

    private void writeByte(byte by) {
        this.output[this.currentPos++] = by;
    }

    private int writeString(String string) {
        int n = 0;
        try {
            byte[] byArray = string.getBytes("ISO-8859-1");
            System.arraycopy(byArray, 0, this.output, this.currentPos, byArray.length);
            n = byArray.length;
            this.currentPos += n;
        }
        catch (Exception exception) {}
        return n;
    }

    private void writeULong(int n) {
        byte by = (byte)(n >> 24 & 0xFF);
        byte by2 = (byte)(n >> 16 & 0xFF);
        byte by3 = (byte)(n >> 8 & 0xFF);
        byte by4 = (byte)(n & 0xFF);
        this.writeByte(by);
        this.writeByte(by2);
        this.writeByte(by3);
        this.writeByte(by4);
    }

    private void writeULong(int n, int n2) {
        byte by = (byte)(n2 >> 24 & 0xFF);
        byte by2 = (byte)(n2 >> 16 & 0xFF);
        byte by3 = (byte)(n2 >> 8 & 0xFF);
        byte by4 = (byte)(n2 & 0xFF);
        this.output[n] = by;
        this.output[n + 1] = by2;
        this.output[n + 2] = by3;
        this.output[n + 3] = by4;
    }

    private void writeUShort(int n) {
        byte by = (byte)(n >> 8 & 0xFF);
        byte by2 = (byte)(n & 0xFF);
        this.writeByte(by);
        this.writeByte(by2);
    }

    private void writeUShort(int n, int n2) {
        byte by = (byte)(n2 >> 8 & 0xFF);
        byte by2 = (byte)(n2 & 0xFF);
        this.output[n] = by;
        this.output[n + 1] = by2;
    }
}

