/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.pdf.DCTFilter;

public class JpegImage
extends AbstractFopImage {
    boolean hasAPPEMarker = false;
    boolean found_icc_profile = false;
    boolean found_dimensions = false;

    public JpegImage(URL uRL) throws FopImageException {
        super(uRL);
    }

    public JpegImage(URL uRL, ImageReader imageReader) throws FopImageException {
        super(uRL, imageReader);
    }

    private int calcBytes(byte by, byte by2) {
        return this.uByte(by) * 256 + this.uByte(by2);
    }

    protected void loadImage() throws FopImageException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        this.m_colorSpace = new ColorSpace(ColorSpace.DEVICE_UNKNOWN);
        byte[] byArray2 = new byte[4096];
        int n = 0;
        boolean bl = true;
        this.m_compressionType = new DCTFilter();
        this.m_compressionType.setApplied(true);
        try {
            int n2;
            InputStream inputStream = this.m_href.openStream();
            while ((n2 = inputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + iOException.getClass() + " - " + iOException.getMessage());
        }
        this.m_bitmaps = byteArrayOutputStream.toByteArray();
        this.m_bitsPerPixel = 8;
        this.m_isTransparent = false;
        if (this.m_bitmaps.length > n + 2 && this.uByte(this.m_bitmaps[n]) == 255 && this.uByte(this.m_bitmaps[n + 1]) == 216) {
            n += 2;
            while (n < this.m_bitmaps.length && bl) {
                if (this.m_bitmaps.length > n + 2 && this.uByte(this.m_bitmaps[n]) == 255) {
                    if (this.uByte(this.m_bitmaps[n + 1]) == 192 || this.uByte(this.m_bitmaps[n + 1]) == 194) {
                        this.m_height = this.calcBytes(this.m_bitmaps[n + 5], this.m_bitmaps[n + 6]);
                        this.m_width = this.calcBytes(this.m_bitmaps[n + 7], this.m_bitmaps[n + 8]);
                        if (this.m_bitmaps[n + 9] == 1) {
                            this.m_colorSpace.setColorSpace(ColorSpace.DEVICE_GRAY);
                        } else if (this.m_bitmaps[n + 9] == 3) {
                            this.m_colorSpace.setColorSpace(ColorSpace.DEVICE_RGB);
                        } else if (this.m_bitmaps[n + 9] == 4) {
                            this.m_colorSpace.setColorSpace(ColorSpace.DEVICE_CMYK);
                        }
                        this.found_dimensions = true;
                        if (this.found_icc_profile) {
                            bl = false;
                            break;
                        }
                        n += this.calcBytes(this.m_bitmaps[n + 2], this.m_bitmaps[n + 3]) + 2;
                        continue;
                    }
                    if (this.uByte(this.m_bitmaps[n + 1]) == 226 && this.m_bitmaps.length > n + 60) {
                        byArray = new byte[11];
                        System.arraycopy(this.m_bitmaps, n + 4, byArray, 0, 11);
                        if ("ICC_PROFILE".equals(new String(byArray))) {
                            int n3 = this.calcBytes(this.m_bitmaps[n + 2], this.m_bitmaps[n + 3]) + 2;
                            if (byteArrayOutputStream2.size() == 0) {
                                byteArrayOutputStream2.write(this.m_bitmaps, n + 18, n3 - 20);
                            } else {
                                byteArrayOutputStream2.write(this.m_bitmaps, n + 16, n3 - 18);
                            }
                        }
                        n += this.calcBytes(this.m_bitmaps[n + 2], this.m_bitmaps[n + 3]) + 2;
                        continue;
                    }
                    if (this.uByte(this.m_bitmaps[n]) == 255 && this.uByte(this.m_bitmaps[n + 1]) == 238 && this.uByte(this.m_bitmaps[n + 2]) == 0 && this.uByte(this.m_bitmaps[n + 3]) == 14 && "Adobe".equals(new String(this.m_bitmaps, n + 4, 5))) {
                        this.hasAPPEMarker = true;
                        n += this.calcBytes(this.m_bitmaps[n + 2], this.m_bitmaps[n + 3]) + 2;
                        continue;
                    }
                    n += this.calcBytes(this.m_bitmaps[n + 2], this.m_bitmaps[n + 3]) + 2;
                    continue;
                }
                bl = false;
            }
        } else {
            throw new FopImageException("\n1 Error while loading image " + this.m_href.toString() + " : JpegImage - Invalid JPEG Header.");
        }
        if (byteArrayOutputStream2.size() > 0) {
            byArray = new byte[byteArrayOutputStream2.size() % 8 + 8];
            try {
                byteArrayOutputStream2.write(byArray);
            }
            catch (Exception exception) {
                throw new FopImageException("\n1 Error while loading image " + this.m_href.toString() + " : " + exception.getMessage());
            }
            this.m_colorSpace.setICCProfile(byteArrayOutputStream2.toByteArray());
        }
        if (this.hasAPPEMarker && this.m_colorSpace.getColorSpace() == ColorSpace.DEVICE_CMYK) {
            this.m_invertImage = true;
        }
    }

    private int uByte(byte by) {
        if (by < 0) {
            return 256 + by;
        }
        return by;
    }
}

