/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.jar.Manifest;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.DocumentJarClassLoader;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.ScriptHandler;
import org.apache.batik.script.Window;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGSVGElement;

public class BaseScriptingEnvironment {
    protected static final String EVENT_NAME = "event";
    protected static final String ALTERNATE_EVENT_NAME = "evt";
    protected BridgeContext bridgeContext;
    protected UserAgent userAgent;
    protected Document document;

    public static boolean isDynamicDocument(Document document) {
        Element element = document.getDocumentElement();
        if (element.getNamespaceURI().equals("http://www.w3.org/2000/svg")) {
            if (element.getAttributeNS(null, "onabort").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onresize").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onunload").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onscroll").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onzoom").length() > 0) {
                return true;
            }
            return BaseScriptingEnvironment.isDynamicElement(document.getDocumentElement());
        }
        return false;
    }

    public static boolean isDynamicElement(Element element) {
        if (element.getNamespaceURI().equals("http://www.w3.org/2000/svg")) {
            String string = element.getLocalName();
            if (string.equals("script")) {
                return true;
            }
            if (string.startsWith("animate") || string.equals("set")) {
                return true;
            }
            if (element.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onactivate").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onclick").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onfocusin").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onfocusout").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmousedown").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmousemove").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseout").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseover").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseup").length() > 0) {
                return true;
            }
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && BaseScriptingEnvironment.isDynamicElement((Element)node)) {
                    return true;
                }
                node = node.getNextSibling();
            }
        }
        return false;
    }

    public BaseScriptingEnvironment(BridgeContext bridgeContext) {
        this.bridgeContext = bridgeContext;
        this.document = bridgeContext.getDocument();
        this.userAgent = this.bridgeContext.getUserAgent();
    }

    public org.apache.batik.script.Window createWindow(Interpreter interpreter, String string) {
        return new Window(interpreter, string);
    }

    public org.apache.batik.script.Window createWindow() {
        return this.createWindow(null, null);
    }

    public void initializeEnvironment(Interpreter interpreter, String string) {
        interpreter.bindObject("window", this.createWindow(interpreter, string));
    }

    public void loadScripts() {
        org.apache.batik.script.Window window = null;
        NodeList nodeList = this.document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "script");
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        while (n2 < n) {
            block21: {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Element element = (Element)nodeList.item(n2);
                String string = element.getAttributeNS(null, "type");
                if (string.length() == 0) {
                    string = "text/ecmascript";
                }
                if (string.equals("application/java-archive")) {
                    try {
                        String string2;
                        object5 = XLinkSupport.getXLinkHref(element);
                        object4 = new URL(XMLBaseSupport.getCascadedXMLBase(element));
                        object4 = new URL((URL)object4, (String)object5);
                        this.checkCompatibleScriptURL(string, (URL)object4);
                        object3 = ((SVGOMDocument)this.document).getURLObject();
                        object2 = new DocumentJarClassLoader((URL)object4, (URL)object3);
                        object4 = ((URLClassLoader)object2).findResource("META-INF/MANIFEST.MF");
                        if (object4 != null && (string2 = ((Manifest)(object = new Manifest(((URL)object4).openStream()))).getMainAttributes().getValue("Script-Handler")) != null) {
                            ScriptHandler scriptHandler = (ScriptHandler)((ClassLoader)object2).loadClass(string2).newInstance();
                            if (window == null) {
                                window = this.createWindow();
                            }
                            scriptHandler.run(this.document, window);
                        }
                        break block21;
                    }
                    catch (Exception exception) {
                        if (this.userAgent != null) {
                            this.userAgent.displayError(exception);
                        }
                        break block21;
                    }
                }
                object5 = this.bridgeContext.getInterpreter(string);
                if (object5 == null) {
                    object4 = this.bridgeContext.getUserAgent();
                    if (object4 != null) {
                        object4.displayError(new Exception("Unknown language: " + string));
                    }
                    return;
                }
                if (!hashSet.contains(string)) {
                    hashSet.add(string);
                    this.initializeEnvironment((Interpreter)object5, string);
                }
                try {
                    object4 = XLinkSupport.getXLinkHref(element);
                    if (((String)object4).length() > 0) {
                        object2 = new URL(XMLBaseSupport.getCascadedXMLBase(element));
                        object2 = new URL((URL)object2, (String)object4);
                        this.checkCompatibleScriptURL(string, (URL)object2);
                        object3 = new InputStreamReader(((URL)object2).openStream());
                    } else {
                        object2 = element.getFirstChild();
                        if (object2 == null) break block21;
                        object = new StringBuffer();
                        while (object2 != null) {
                            ((StringBuffer)object).append(object2.getNodeValue());
                            object2 = object2.getNextSibling();
                        }
                        object3 = new StringReader(((StringBuffer)object).toString());
                    }
                    object5.evaluate((Reader)object3);
                }
                catch (IOException iOException) {
                    if (this.userAgent != null) {
                        this.userAgent.displayError(iOException);
                    }
                    return;
                }
                catch (InterpreterException interpreterException) {
                    this.handleInterpreterException(interpreterException);
                    return;
                }
                catch (SecurityException securityException) {
                    if (this.userAgent == null) break block21;
                    this.userAgent.displayError(securityException);
                }
            }
            ++n2;
        }
    }

    private void checkCompatibleScriptURL(String string, URL uRL) {
        URL uRL2 = ((SVGOMDocument)this.document).getURLObject();
        ScriptSecurity scriptSecurity = this.userAgent.getScriptSecurity(string, uRL, uRL2);
        if (scriptSecurity == null) {
            scriptSecurity = new DefaultScriptSecurity(string, uRL, uRL2);
        }
        scriptSecurity.checkLoadScript();
    }

    public void dispatchSVGLoadEvent() {
        SVGSVGElement sVGSVGElement = (SVGSVGElement)this.document.getDocumentElement();
        String string = sVGSVGElement.getContentScriptType();
        Interpreter interpreter = this.bridgeContext.getInterpreter(string);
        if (interpreter == null) {
            UserAgent userAgent = this.bridgeContext.getUserAgent();
            if (userAgent != null) {
                userAgent.displayError(new Exception("Unknown language: " + string));
            }
            return;
        }
        this.dispatchSVGLoad(sVGSVGElement, interpreter);
    }

    protected void dispatchSVGLoad(Element element, final Interpreter interpreter) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                this.dispatchSVGLoad((Element)node, interpreter);
            }
            node = node.getNextSibling();
        }
        DocumentEvent documentEvent = (DocumentEvent)((Object)element.getOwnerDocument());
        Event event = documentEvent.createEvent("SVGEvents");
        event.initEvent("SVGLoad", false, false);
        EventTarget eventTarget = (EventTarget)((Object)element);
        final String string = element.getAttributeNS(null, "onload");
        EventListener eventListener = null;
        if (string.length() > 0) {
            eventListener = new EventListener(){

                public void handleEvent(Event event) {
                    try {
                        interpreter.bindObject(BaseScriptingEnvironment.EVENT_NAME, event);
                        interpreter.bindObject(BaseScriptingEnvironment.ALTERNATE_EVENT_NAME, event);
                        interpreter.evaluate(new StringReader(string));
                    }
                    catch (IOException iOException) {
                    }
                    catch (InterpreterException interpreterException) {
                        BaseScriptingEnvironment.this.handleInterpreterException(interpreterException);
                    }
                }
            };
            eventTarget.addEventListener("SVGLoad", eventListener, false);
        }
        eventTarget.dispatchEvent(event);
        if (string.length() > 0) {
            eventTarget.removeEventListener("SVGLoad", eventListener, false);
        }
    }

    protected void handleInterpreterException(InterpreterException interpreterException) {
        if (this.userAgent != null) {
            Exception exception = interpreterException.getException();
            this.userAgent.displayError(exception == null ? interpreterException : exception);
        }
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;

        public Window(Interpreter interpreter, String string) {
            this.interpreter = interpreter;
            this.language = string;
        }

        public Object setInterval(String string, long l) {
            return null;
        }

        public Object setInterval(Runnable runnable, long l) {
            return null;
        }

        public void clearInterval(Object object) {
        }

        public Object setTimeout(String string, long l) {
            return null;
        }

        public Object setTimeout(Runnable runnable, long l) {
            return null;
        }

        public void clearTimeout(Object object) {
        }

        public DocumentFragment parseXML(String string, Document document) {
            return null;
        }

        public void getURL(String string, Window.GetURLHandler getURLHandler) {
        }

        public void getURL(String string, Window.GetURLHandler getURLHandler, String string2) {
        }

        public void alert(String string) {
        }

        public boolean confirm(String string) {
            return false;
        }

        public String prompt(String string) {
            return null;
        }

        public String prompt(String string, String string2) {
            return null;
        }

        public BridgeContext getBridgeContext() {
            return BaseScriptingEnvironment.this.bridgeContext;
        }

        public Interpreter getInterpreter() {
            return this.interpreter;
        }
    }
}

