/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import org.apache.batik.dom.util.DocumentDescriptor;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.dom.util.HashTableStack;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXDocumentFactory
extends DefaultHandler
implements LexicalHandler,
DocumentFactory {
    protected DOMImplementation implementation;
    protected String parserClassName;
    protected Document document;
    protected DocumentDescriptor documentDescriptor;
    protected boolean createDocumentDescriptor;
    protected Node currentNode;
    protected Locator locator;
    protected boolean inCDATA;
    protected boolean inDTD;
    protected boolean isValidating;
    protected boolean documentElementParsed;
    protected HashTableStack namespaces;
    protected ErrorHandler errorHandler;

    public SAXDocumentFactory(DOMImplementation dOMImplementation, String string) {
        this.implementation = dOMImplementation;
        this.parserClassName = string;
    }

    public SAXDocumentFactory(DOMImplementation dOMImplementation, String string, boolean bl) {
        this.implementation = dOMImplementation;
        this.parserClassName = string;
        this.createDocumentDescriptor = bl;
    }

    public Document createDocument(String string, String string2, String string3) throws IOException {
        return this.createDocument(string, string2, string3, new InputSource(string3));
    }

    public Document createDocument(String string, String string2, String string3, InputStream inputStream) throws IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string3);
        return this.createDocument(string, string2, string3, inputSource);
    }

    public Document createDocument(String string, String string2, String string3, Reader reader) throws IOException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string3);
        return this.createDocument(string, string2, string3, inputSource);
    }

    protected Document createDocument(String string, String string2, String string3, InputSource inputSource) throws IOException {
        this.document = this.implementation.createDocument(string, string2, null);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(this.parserClassName);
            xMLReader.setContentHandler(this);
            xMLReader.setDTDHandler(this);
            xMLReader.setEntityResolver(this);
            xMLReader.setErrorHandler(this.errorHandler == null ? this : this.errorHandler);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", this.isValidating);
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null && exception instanceof InterruptedIOException) {
                throw (InterruptedIOException)exception;
            }
            throw new IOException(sAXException.getMessage());
        }
        return this.document;
    }

    public DocumentDescriptor getDocumentDescriptor() {
        return this.documentDescriptor;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setValidating(boolean bl) {
        this.isValidating = bl;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void startDocument() throws SAXException {
        this.namespaces = new HashTableStack();
        this.namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.put("xmlns", "http://www.w3.org/2000/xmlns/");
        this.namespaces.put("", null);
        this.documentElementParsed = false;
        this.inCDATA = false;
        this.inDTD = false;
        this.currentNode = this.document;
        this.documentDescriptor = this.createDocumentDescriptor ? new DocumentDescriptor() : null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        Object object;
        if (Thread.currentThread().isInterrupted()) {
            throw new SAXException(new InterruptedIOException());
        }
        int n = attributes.getLength();
        this.namespaces.push();
        int n2 = 0;
        while (n2 < n) {
            String string5;
            object = attributes.getQName(n2);
            if (((String)object).equals("xmlns")) {
                string5 = attributes.getValue(n2);
                if (string5.length() == 0) {
                    string5 = null;
                }
                this.namespaces.put("", string5);
            } else if (((String)object).startsWith("xmlns:")) {
                string5 = attributes.getValue(n2);
                if (string5.length() == 0) {
                    string5 = null;
                }
                int n3 = ((String)object).indexOf(58);
                this.namespaces.put(((String)object).substring(n3 + 1), string5);
            }
            ++n2;
        }
        int n4 = string3.indexOf(58);
        String string6 = n4 == -1 || n4 == string3.length() - 1 ? "" : string3.substring(0, n4);
        String string7 = this.namespaces.get(string6);
        if (this.currentNode == this.document) {
            Attr attr;
            Attr attr2;
            object = this.document.getDocumentElement();
            String string8 = string3;
            if (n4 != -1 && n4 != string3.length() - 1) {
                string8 = string3.substring(n4 + 1);
            }
            if (object.getNamespaceURI() != null && string6.length() != 0) {
                if (!object.getLocalName().equals(string8)) {
                    throw new SAXException("Bad root element");
                }
                object.setPrefix(string6);
            }
            if (string6.equals("")) {
                string4 = "xmlns";
                attr2 = object.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
            } else {
                string4 = "xmlns:" + string6;
                attr2 = attr = object.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string4);
            }
            if (attr != null) {
                this.namespaces.put(string6, attr.getValue());
            }
            this.documentElementParsed = true;
        } else {
            object = this.document.createElementNS(string7, string3);
            this.currentNode.appendChild((Node)object);
        }
        this.currentNode = object;
        if (this.createDocumentDescriptor && this.locator != null) {
            this.documentDescriptor.setLocationLine((Element)object, this.locator.getLineNumber());
        }
        int n5 = 0;
        while (n5 < n) {
            string4 = attributes.getQName(n5);
            if (string4.equals("xmlns")) {
                object.setAttributeNS("http://www.w3.org/2000/xmlns/", string4, attributes.getValue(n5));
            } else {
                n4 = string4.indexOf(58);
                string7 = n4 == -1 ? null : this.namespaces.get(string4.substring(0, n4));
                object.setAttributeNS(string7, string4, attributes.getValue(n5));
            }
            ++n5;
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.currentNode = this.currentNode.getParentNode();
        this.namespaces.pop();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        Text text = this.inCDATA ? this.document.createCDATASection(string) : this.document.createTextNode(string);
        this.currentNode.appendChild(text);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (!this.inDTD) {
            ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(string, string2);
            if (this.currentNode == this.document && !this.documentElementParsed) {
                this.currentNode.insertBefore(processingInstruction, this.document.getDocumentElement());
            } else {
                this.currentNode.appendChild(processingInstruction);
            }
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.inCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.inCDATA = false;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.inDTD) {
            Comment comment = this.document.createComment(new String(cArray, n, n2));
            if (this.currentNode == this.document && !this.documentElementParsed) {
                this.currentNode.insertBefore(comment, this.document.getDocumentElement());
            } else {
                this.currentNode.appendChild(comment);
            }
        }
    }
}

