/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.GraphicsNodeChangeAdapter;
import org.apache.batik.gvt.event.GraphicsNodeChangeEvent;

public class UpdateTracker
extends GraphicsNodeChangeAdapter {
    Map dirtyNodes = null;
    Map nodeBounds = new HashMap();

    public boolean hasChanged() {
        return this.dirtyNodes != null;
    }

    public List getDirtyAreas() {
        if (this.dirtyNodes == null) {
            return null;
        }
        LinkedList<Rectangle2D> linkedList = new LinkedList<Rectangle2D>();
        Set set = this.dirtyNodes.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            GraphicsNode graphicsNode = (GraphicsNode)weakReference.get();
            if (graphicsNode == null) continue;
            AffineTransform affineTransform = (AffineTransform)this.dirtyNodes.get(weakReference);
            Rectangle2D rectangle2D = (Rectangle2D)this.nodeBounds.get(weakReference);
            Rectangle2D rectangle2D2 = graphicsNode.getBounds();
            AffineTransform affineTransform2 = graphicsNode.getTransform();
            if (affineTransform2 != null) {
                affineTransform2 = affineTransform2 == null ? null : new AffineTransform(affineTransform2);
            }
            this.nodeBounds.put(weakReference, rectangle2D2);
            Shape shape = rectangle2D;
            Shape shape2 = rectangle2D2;
            while ((graphicsNode = graphicsNode.getParent()) != null && this.dirtyNodes.get(graphicsNode.getWeakReference()) == null) {
                AffineTransform affineTransform3 = graphicsNode.getTransform();
                if (affineTransform != null) {
                    if (affineTransform3 != null) {
                        affineTransform.preConcatenate(affineTransform3);
                    }
                } else {
                    AffineTransform affineTransform4 = affineTransform = affineTransform3 == null ? null : new AffineTransform(affineTransform3);
                }
                if (affineTransform2 != null) {
                    if (affineTransform3 == null) continue;
                    affineTransform2.preConcatenate(affineTransform3);
                    continue;
                }
                affineTransform2 = affineTransform3 == null ? null : new AffineTransform(affineTransform3);
            }
            if (graphicsNode != null) continue;
            if (affineTransform != null) {
                shape = affineTransform.createTransformedShape(rectangle2D);
            }
            if (affineTransform2 != null) {
                shape2 = affineTransform2.createTransformedShape(rectangle2D2);
            }
            if (shape != null) {
                linkedList.add((Rectangle2D)shape);
            }
            if (shape2 == null) continue;
            linkedList.add((Rectangle2D)shape2);
        }
        return linkedList;
    }

    public void changeStarted(GraphicsNodeChangeEvent graphicsNodeChangeEvent) {
        GraphicsNode graphicsNode = graphicsNodeChangeEvent.getGraphicsNode();
        WeakReference weakReference = graphicsNode.getWeakReference();
        boolean bl = false;
        if (this.dirtyNodes == null) {
            this.dirtyNodes = new HashMap();
            bl = true;
        } else if (!this.dirtyNodes.containsKey(weakReference)) {
            bl = true;
        }
        if (bl) {
            AffineTransform affineTransform = graphicsNode.getTransform();
            if (affineTransform != null) {
                affineTransform = (AffineTransform)affineTransform.clone();
            }
            this.dirtyNodes.put(weakReference, affineTransform);
        }
        while (!this.nodeBounds.containsKey(weakReference)) {
            this.nodeBounds.put(weakReference, graphicsNode.getBounds());
            graphicsNode = graphicsNode.getParent();
            if (graphicsNode == null) break;
            weakReference = graphicsNode.getWeakReference();
        }
    }

    public void clear() {
        this.dirtyNodes = null;
    }

    public static class DirtyInfo {
        WeakReference gn;
        AffineTransform gn2parent;

        public DirtyInfo(GraphicsNode graphicsNode, AffineTransform affineTransform) {
            this.gn = graphicsNode.getWeakReference();
            this.gn2parent = affineTransform;
        }

        public GraphicsNode getGraphicsNode() {
            return (GraphicsNode)this.gn.get();
        }

        public AffineTransform getGn2Parent() {
            return this.gn2parent;
        }
    }
}

